DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -3.52151091401099E-12   0.00000000000000E+00  -7.63373197563139E-10   1.59629341615402E-22
      4.28496253622641E-09   3.52158933866343E-09  -7.94952621556914E-19  -2.47846792153659E-01  -2.47846792161905E-01
      0.00000000000000E+00   0.00000000000000E+00   8.24663290353796E-09   0.00000000000000E+00   8.24663290353796E-09
      3.70485193211917E-18  -2.47846792153655E-01  -2.44139204126641E-01   0.00000000000000E+00   2.44091921848716E-11
     -9.83204380319249E-23  -1.17926314343874E-08  -1.17682222422026E-08  -2.90989931056225E-18
      1.17500000000000E-12
      0.00000000000000E+00  -3.54245151409431E-12   0.00000000000000E+00  -5.10456624971370E-11   1.52004576583301E-22
      3.59345855806788E-09   3.54241289557089E-09  -7.99779131575742E-19  -2.45758708979512E-01  -2.45758708987287E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77521311473673E-09   0.00000000000000E+00   7.77521311473673E-09
      3.71010020097161E-18  -2.45758708979509E-01  -2.42193067398458E-01   0.00000000000000E+00   3.28865241615724E-11
     -9.82940725672035E-23  -1.13505125344693E-08  -1.13176260103079E-08  -2.91032106939587E-18
      1.63062500000000E-12
      0.00000000000000E+00  -3.55549346677778E-12   0.00000000000000E+00  -4.01579895979533E-12   1.46010493403276E-22
      3.55948600422179E-09   3.55547020526214E-09  -8.02853241040648E-19  -2.44452979472819E-01  -2.44452979480243E-01
      0.00000000000000E+00   0.00000000000000E+00   7.42462877089689E-09   0.00000000000000E+00   7.42462877089689E-09
      3.71348304745535E-18  -2.44452979472818E-01  -2.40993677520440E-01   0.00000000000000E+00   3.60857367381589E-11
     -9.82760747166167E-23  -1.10161847128983E-08  -1.09800989761602E-08  -2.91062980641470E-18
      2.24571875000000E-12
      0.00000000000000E+00  -3.57184183000072E-12   0.00000000000000E+00   6.59592511467750E-13   1.37576381171120E-22
      3.57118559781225E-09   3.57184519032386E-09  -8.06706042853560E-19  -2.42815955710230E-01  -2.42815955717169E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93804596276184E-09   0.00000000000000E+00   6.93804596276184E-09
      3.71775059616426E-18  -2.42815955710230E-01  -2.39504795656912E-01   0.00000000000000E+00   3.69561031086544E-11
     -9.82529838228830E-23  -1.05468472561925E-08  -1.05098911530839E-08  -2.91104455331070E-18
      3.07609531250000E-12
      0.00000000000000E+00  -3.59195582744916E-12   0.00000000000000E+00   9.37089420939814E-13   1.26894946454620E-22
      3.59107293422143E-09   3.59201002364250E-09  -8.11436679895855E-19  -2.40800255159455E-01  -2.40800255165773E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31788741015489E-09   0.00000000000000E+00   6.31788741015489E-09
      3.72299682179417E-18  -2.40800255159454E-01  -2.37678126630235E-01   0.00000000000000E+00   3.48666247884288E-11
     -9.82249396915761E-23  -9.94476405858593E-09  -9.90989743379760E-09  -2.91156014189832E-18
      4.19710367187500E-12
      0.00000000000000E+00  -3.61620283807195E-12   0.00000000000000E+00   8.68596506986262E-13   1.14456091951284E-22
      3.61537908723390E-09   3.61624768374100E-09  -8.17101668032612E-19  -2.38378189372836E-01  -2.38378189378424E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58781989012139E-09   0.00000000000000E+00   5.58781989012139E-09
      3.72926081460168E-18  -2.38378189372834E-01  -2.35478438652247E-01   0.00000000000000E+00   3.04549794981952E-11
     -9.81923041473730E-23  -9.23452255336031E-09  -9.20406757386221E-09  -2.91215914656906E-18
      5.71046495703125E-12
      0.00000000000000E+00  -3.64449101713187E-12   0.00000000000000E+00   7.86260578944303E-13   1.00902700181562E-22
      3.64375710410121E-09   3.64454336468026E-09  -8.23686434897766E-19  -2.35551938020393E-01  -2.35551938025178E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78528303513103E-09   0.00000000000000E+00   4.78528303513103E-09
      3.73650267668556E-18  -2.35551938020390E-01  -2.32896123079444E-01   0.00000000000000E+00   2.48734346628043E-11
     -9.81556867311911E-23  -8.45469983447474E-09  -8.42982639981203E-09  -2.91281624178779E-18
      7.75350269199219E-12
      0.00000000000000E+00  -3.67636114094288E-12   0.00000000000000E+00   7.21475776958503E-13   8.69457917302401E-23
      3.67574073685243E-09   3.67646221262948E-09  -8.31077810893658E-19  -2.32365739487358E-01  -2.32365739491313E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95445176752841E-09   0.00000000000000E+00   3.95445176752841E-09
      3.74458177086770E-18  -2.32365739487359E-01  -2.29961640487159E-01   0.00000000000000E+00   1.91337702684213E-11
     -9.81161074528168E-23  -7.65004775042636E-09  -7.63091398015804E-09  -2.91350395997404E-18
      1.05116036341895E-11
      0.00000000000000E+00  -3.71080291739570E-12   0.00000000000000E+00   6.84831682928623E-13   7.33096299328614E-23
      3.71036804429724E-09   3.71105287598024E-09  -8.39045543359332E-19  -2.28915116591930E-01  -2.28915116595071E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14087052241681E-09   0.00000000000000E+00   3.14087052241681E-09
      3.75324460881490E-18  -2.28915116591937E-01  -2.26756465907697E-01   0.00000000000000E+00   1.38931441793026E-11
     -9.80750084459592E-23  -6.86581654257624E-09  -6.85192339839704E-09  -2.91419906545557E-18
      1.42350399061558E-11
      0.00000000000000E+00  -3.74643867543222E-12   0.00000000000000E+00   6.77315221782753E-13   6.06695687865327E-23
      3.74614472031236E-09   3.74682203553420E-09  -8.47241695963002E-19  -2.25348878470455E-01  -2.25348878472841E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38661385804178E-09   0.00000000000000E+00   2.38661385804178E-09
      3.76213101342111E-18  -2.25348878470469E-01  -2.23416621691371E-01   0.00000000000000E+00   9.49303893271974E-12
     -9.80341119760550E-23  -6.14292893250838E-09  -6.13343589357576E-09  -2.91488931745811E-18
      1.92616788733103E-11
      0.00000000000000E+00  -3.78143152030829E-12   0.00000000000000E+00   2.64572602377971E-13   4.95826342848113E-23
      3.78113982656907E-09   3.78140439917149E-09  -8.55226480720729E-19  -2.21859559985408E-01  -2.21859559987134E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72578446149150E-09   0.00000000000000E+00   1.72578446149150E-09
      3.77080590884415E-18  -2.21859559985419E-01  -2.20124505178246E-01   0.00000000000000E+00   6.47413893213128E-12
     -9.79952576105870E-23  -5.51366299959527E-09  -5.50718886066323E-09  -2.91557942812342E-18
      2.60476414789689E-11
      0.00000000000000E+00  -3.81339348885651E-12   0.00000000000000E+00   1.79139220220856E-13   4.04418383647386E-23
      3.81321398404529E-09   3.81339312326555E-09  -8.62522110948259E-19  -2.18660687563427E-01  -2.18660687564607E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18062220462546E-09   0.00000000000000E+00   1.18062220462546E-09
      3.77881756697616E-18  -2.18660687563429E-01  -2.17087308775636E-01   0.00000000000000E+00   4.05570452521009E-12
     -9.79598060809195E-23  -4.99807103241608E-09  -4.99401532789097E-09  -2.91629545602789E-18
      3.52086909966080E-11
      0.00000000000000E+00  -3.84048768633273E-12   0.00000000000000E+00   1.12461583144408E-13   3.34419034110673E-23
      3.84041500346986E-09   3.84052746505304E-09  -8.68701300030885E-19  -2.15947253417740E-01  -2.15947253418500E-01
      0.00000000000000E+00   0.00000000000000E+00   7.60671285361172E-10   0.00000000000000E+00   7.60671285361172E-10
      3.78578611428799E-18  -2.15947253417727E-01  -2.14497632068336E-01   0.00000000000000E+00   2.40587066751212E-12
     -9.79287249158440E-23  -4.60360462108163E-09  -4.60119875041421E-09  -2.91708481425711E-18
      4.75761078454208E-11
      0.00000000000000E+00  -3.86152013115325E-12   0.00000000000000E+00   6.46655434439405E-14   2.85753168880941E-23
      3.86145944734247E-09   3.86152411288595E-09  -8.73491195858604E-19  -2.13847588728201E-01  -2.13847588728664E-01
      0.00000000000000E+00   0.00000000000000E+00   4.62548650477015E-10   0.00000000000000E+00   4.62548650477015E-10
      3.79150664626130E-18  -2.13847588728176E-01  -2.12485276343844E-01   0.00000000000000E+00   1.35407327628073E-12
     -9.79020602744977E-23  -4.32542683663920E-09  -4.32407276336301E-09  -2.91801545040269E-18
      6.42721205913181E-11
      0.00000000000000E+00  -3.87621528910646E-12   0.00000000000000E+00   3.38159034771044E-14   2.56389556855928E-23
      3.87614690444855E-09   3.87618072035205E-09  -8.76860350078852E-19  -2.12381928031962E-01  -2.12381928032234E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71226427534625E-10   0.00000000000000E+00   2.71226427534625E-10
      3.79603504615244E-18  -2.12381928031922E-01  -2.11075274415383E-01   0.00000000000000E+00   7.34702206551416E-13
     -9.78787909902492E-23  -4.14814185009316E-09  -4.14740714788671E-09  -2.91917469607358E-18
      8.68117377982794E-11
      0.00000000000000E+00  -3.88549160756442E-12   0.00000000000000E+00   2.30063250747175E-13   2.42743856972180E-23
      3.88544492048804E-09   3.88567498373882E-09  -8.79032908742505E-19  -2.11453875673859E-01  -2.11453875674022E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62755968131411E-10   0.00000000000000E+00   1.62755968131411E-10
      3.79970350337227E-18  -2.11453875673751E-01  -2.10178471973417E-01   0.00000000000000E+00   1.90759732068113E-13
     -9.78568004666833E-23  -4.04862171160220E-09  -4.04843095187023E-09  -2.92067059462977E-18
      1.17240221027677E-10
      0.00000000000000E+00  -3.89109413653408E-12   0.00000000000000E+00   9.91905694399976E-14   2.40522221799036E-23
      3.89111902204150E-09   3.89121821261096E-09  -8.80403680646456E-19  -2.10887313073418E-01  -2.10887313073528E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09633952901308E-10   0.00000000000000E+00   1.09633952901308E-10
      3.80303949826950E-18  -2.10887313073567E-01  -2.09626860535053E-01   0.00000000000000E+00   1.57530218045736E-13
     -9.78333976758281E-23  -4.00100969573015E-09  -4.00085216551221E-09  -2.92263581762304E-18
      1.58318673387364E-10
      0.00000000000000E+00  -3.89504346023400E-12   0.00000000000000E+00   3.17048862573468E-14   2.45998392968700E-23
      3.89501836074915E-09   3.89505006563544E-09  -8.81377204729054E-19  -2.10497725540280E-01  -2.10497725540367E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69674039972937E-11   0.00000000000000E+00   8.69674039972937E-11
      3.80661198463145E-18  -2.10497725541598E-01  -2.09243186660201E-01   0.00000000000000E+00   1.57325400080442E-13
     -9.78053851937689E-23  -3.98217479503278E-09  -3.98201746963279E-09  -2.92523477990239E-18
      2.08318673387364E-10
      0.00000000000000E+00  -3.89825802603627E-12   0.00000000000000E+00   7.51414638599183E-15   2.55744649238903E-23
      3.89825197656739E-09   3.89825949071380E-09  -8.82177614394285E-19  -2.10174481967398E-01  -2.10174481967476E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80785500915563E-11   0.00000000000000E+00   7.80785500915563E-11
      3.81051591213603E-18  -2.10174481970937E-01  -2.08921725062850E-01   0.00000000000000E+00   1.56482626281576E-13
     -9.77731027972584E-23  -3.97649452343152E-09  -3.97633804080534E-09  -2.92833829774174E-18
      2.58318673387364E-10
      0.00000000000000E+00  -3.90101336815249E-12   0.00000000000000E+00   3.15219841869421E-15   2.66161651411024E-23
      3.90102617850689E-09   3.90102933070534E-09  -8.82834609327470E-19  -2.09897100643713E-01  -2.09897100643787E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41388984485468E-11   0.00000000000000E+00   7.41388984485468E-11
      3.81422285705845E-18  -2.09897100649206E-01  -2.08644710951764E-01   0.00000000000000E+00   1.50978070721159E-13
     -9.77417142412130E-23  -3.97531920722452E-09  -3.97516822915390E-09  -2.93138824773098E-18
      3.08318673387364E-10
      0.00000000000000E+00  -3.90358502079430E-12   0.00000000000000E+00   2.94095659922243E-15   2.76632211436329E-23
      3.90361867492492E-09   3.90362161588155E-09  -8.83415174762187E-19  -2.09637868279840E-01  -2.09637868279911E-01
      0.00000000000000E+00   0.00000000000000E+00   7.15937694681722E-11   0.00000000000000E+00   7.15937694681722E-11
      3.81780254553186E-18  -2.09637868287397E-01  -2.08385463636037E-01   0.00000000000000E+00   1.45655512578184E-13
     -9.77109584275898E-23  -3.97536104086222E-09  -3.97521538534973E-09  -2.93438737076968E-18
      3.58318673387364E-10
      0.00000000000000E+00  -3.90606482869891E-12   0.00000000000000E+00   2.57880121490856E-15   2.87002902957782E-23
      3.90610589019567E-09   3.90610846899692E-09  -8.83940731046138E-19  -2.09389158824000E-01  -2.09389158824070E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95105739881188E-11   0.00000000000000E+00   6.95105739881188E-11
      3.82127807423127E-18  -2.09389158833375E-01  -2.08136626847125E-01   0.00000000000000E+00   1.41940501166672E-13
     -9.76807436912425E-23  -3.97576098348608E-09  -3.97561904298501E-09  -2.93733734318513E-18
      4.08318673387364E-10
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   1.70228520281569E-15   2.97241356863772E-23
      3.90851155809472E-09   3.90851326037996E-09  -8.84420463072921E-19  -2.09148600896316E-01  -2.09148600896384E-01
      0.00000000000000E+00   0.00000000000000E+00   6.76368205089476E-11   0.00000000000000E+00   6.76368205089476E-11
      3.82465991525672E-18  -2.09148600903738E-01  -2.07895901284294E-01   0.00000000000000E+00   1.39364294355782E-13
     -9.76510385492539E-23  -3.97628944518316E-09  -3.97615008088891E-09  -2.94023945218379E-18
      4.58318673387364E-10
      0.00000000000000E+00  -3.91084075503370E-12   0.00000000000000E+00   2.14151337136521E-15   3.07345338279462E-23
      3.91084541971561E-09   3.91084756122901E-09  -8.84860011656759E-19  -2.08915224053568E-01  -2.08915224053634E-01
      0.00000000000000E+00   0.00000000000000E+00   6.58978489799695E-11   0.00000000000000E+00   6.58978489799695E-11
      3.82795480770571E-18  -2.08915224052628E-01  -2.07662336958106E-01   0.00000000000000E+00   1.35843299901405E-13
     -9.76218089116545E-23  -3.97688125350881E-09  -3.97674541020901E-09  -2.94309479604896E-18
      5.08318673387364E-10
      0.00000000000000E+00  -3.91313687346389E-12   0.00000000000000E+00   1.73309150257754E-15   3.17320263246648E-23
      3.91311319339646E-09   3.91311492648799E-09  -8.85263768854478E-19  -2.08688454087267E-01  -2.08688454087332E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42664137873475E-11   0.00000000000000E+00   6.42664137873475E-11
      3.83116812839508E-18  -2.08688454070266E-01  -2.07435366441230E-01   0.00000000000000E+00   1.33420720603730E-13
     -9.75930424171085E-23  -3.97751476099584E-09  -3.97738134027533E-09  -2.94590435954060E-18
      5.58318673387364E-10
      0.00000000000000E+00  -3.91534114715687E-12   0.00000000000000E+00   2.04175269335845E-15   3.27172405053344E-23
      3.91531931571923E-09   3.91532135747196E-09  -8.85635500055520E-19  -2.08467849696564E-01  -2.08467849696627E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27283875932089E-11   0.00000000000000E+00   6.27283875932089E-11
      3.83430454777474E-18  -2.08467849657909E-01  -2.07214551489044E-01   0.00000000000000E+00   1.30479972718594E-13
     -9.75647187941634E-23  -3.97818022503775E-09  -3.97804974506513E-09  -2.94866904771922E-18
      6.08318673387364E-10
      0.00000000000000E+00  -3.91745357611264E-12   0.00000000000000E+00   1.78836214839366E-15   3.36908011687062E-23
      3.91746754859634E-09   3.91746933695853E-09  -8.85978534258907E-19  -2.08253032711085E-01  -2.08253032711146E-01
      0.00000000000000E+00   0.00000000000000E+00   6.12738949741505E-11   0.00000000000000E+00   6.12738949741505E-11
      3.83736824252345E-18  -2.08253032652039E-01  -2.06999515863564E-01   0.00000000000000E+00   1.28255424270583E-13
     -9.75368262549086E-23  -3.97887148735687E-09  -3.97874323193270E-09  -2.95138970826454E-18
      6.58318673387364E-10
      0.00000000000000E+00  -3.91947416033120E-12   0.00000000000000E+00  -1.49950207756046E-16   3.46532633526819E-23
      3.91956128966116E-09   3.91956113971099E-09  -8.86295844310562E-19  -2.08043664288633E-01  -2.08043664288693E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98949233252669E-11   0.00000000000000E+00   5.98949233252669E-11
      3.84036298868971E-18  -2.08043664219894E-01  -2.06789922186663E-01   0.00000000000000E+00   1.27834517199573E-13
     -9.75093517183672E-23  -3.97958389755333E-09  -3.97945606303623E-09  -2.95406714437915E-18
      7.08318673387364E-10
      0.00000000000000E+00  -3.92158658928698E-12   0.00000000000000E+00   1.79309227191653E-15   3.56051003262455E-23
      3.92160359882409E-09   3.92160539191639E-09  -8.86590081981287E-19  -2.07839439949296E-01  -2.07839439949354E-01
      0.00000000000000E+00   0.00000000000000E+00   5.85843530771315E-11   0.00000000000000E+00   5.85843530771315E-11
      3.84329220634357E-18  -2.07839439895118E-01  -2.06585467271281E-01   0.00000000000000E+00   1.23659987511752E-13
     -9.74822841837660E-23  -3.98031340498095E-09  -3.98018974499353E-09  -2.95670212436228E-18
      7.58318673387364E-10
      0.00000000000000E+00  -3.92360717350554E-12   0.00000000000000E+00   5.83116000898397E-16   3.65467798285553E-23
      3.92359722738536E-09   3.92359781050140E-09  -8.86863627415007E-19  -2.07640081361903E-01  -2.07640081361960E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73362369847676E-11   0.00000000000000E+00   5.73362369847676E-11
      3.84615901819281E-18  -2.07640081366402E-01  -2.06385873811353E-01   0.00000000000000E+00   1.22714443398235E-13
     -9.74556136329287E-23  -3.98105676192947E-09  -3.98093404748617E-09  -2.95929539077780E-18
      8.08318673387364E-10
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00   1.76747357863009E-15   3.74786656965987E-23
      3.92554472335059E-09   3.92554649082421E-09  -8.87118600775707E-19  -2.07445336824167E-01  -2.07445336824223E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61448999395854E-11   0.00000000000000E+00   5.61448999395854E-11
      3.84896626318979E-18  -2.07445336939761E-01  -2.06190891100458E-01   0.00000000000000E+00   1.19467367443495E-13
     -9.74293305810378E-23  -3.98181085813119E-09  -3.98169139076384E-09  -2.96184766241408E-18
      8.58318673387364E-10
      0.00000000000000E+00  -3.92746465246826E-12   0.00000000000000E+00   1.01847821844139E-15   3.84011250401043E-23
      3.92744837088141E-09   3.92744938935967E-09  -8.87356902879612E-19  -2.07254975750638E-01  -2.07254975750693E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50056152098994E-11   0.00000000000000E+00   5.50056152098994E-11
      3.85171654395028E-18  -2.07254976014973E-01  -2.06000289306022E-01   0.00000000000000E+00   1.18209277153872E-13
     -9.74034265037395E-23  -3.98257321384654E-09  -3.98245500456949E-09  -2.96435964107067E-18
      9.08318673387364E-10
      0.00000000000000E+00  -3.92930154721241E-12   0.00000000000000E+00   1.72371604331481E-15   3.93144467215076E-23
      3.92931028998110E-09   3.92931201369718E-09  -8.87580226617121E-19  -2.07068788728228E-01  -2.07068788728282E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39138758365989E-11   0.00000000000000E+00   5.39138758365989E-11
      3.85441223774211E-18  -2.07068789135638E-01  -2.05813859725382E-01   0.00000000000000E+00   1.15570426486740E-13
     -9.73778932104557E-23  -3.98334145996022E-09  -3.98322588953383E-09  -2.96683201112499E-18
      9.58318673387365E-10
      0.00000000000000E+00  -3.93113844195656E-12   0.00000000000000E+00   1.26529685203037E-15   4.02189199201317E-23
      3.93113238707639E-09   3.93113365237328E-09  -8.87790087862007E-19  -2.06886583439200E-01  -2.06886583439253E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28658875801767E-11   0.00000000000000E+00   5.28658875801767E-11
      3.85705553212112E-18  -2.06886583902983E-01  -2.05631410553143E-01   0.00000000000000E+00   1.14138250679471E-13
     -9.73527232937979E-23  -3.98411367820404E-09  -3.98399953995346E-09  -2.96926544425911E-18
      1.00831867338736E-09
      0.00000000000000E+00  -3.93288349196350E-12   0.00000000000000E+00   1.67058870128615E-15   4.11147748832440E-23
      3.93291644226464E-09   3.93291811285338E-09  -8.87987836321406E-19  -2.06708184576627E-01  -2.06708184576678E-01
      0.00000000000000E+00   0.00000000000000E+00   5.18580451485266E-11   0.00000000000000E+00   5.18580451485266E-11
      3.85964843437854E-18  -2.06708184904229E-01  -2.05452766952842E-01   0.00000000000000E+00   1.11903333744142E-13
     -9.73279093892771E-23  -3.98488806133557E-09  -3.98477615800193E-09  -2.97166059805714E-18
      1.05831867338736E-09
      0.00000000000000E+00  -3.93462854197045E-12   0.00000000000000E+00   1.39369638094330E-15   4.20022402982642E-23
      3.93466404987775E-09   3.93466544357417E-09  -8.88174679545797E-19  -2.06533430629263E-01  -2.06533430629313E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08872956160849E-11   0.00000000000000E+00   5.08872956160849E-11
      3.86219279915935E-18  -2.06533430531329E-01  -2.05277767774922E-01   0.00000000000000E+00   1.10385498487136E-13
     -9.73034449099199E-23  -3.98566312468863E-09  -3.98555273919024E-09  -2.97401811961355E-18
      1.10831867338736E-09
      0.00000000000000E+00  -3.93637359197739E-12   0.00000000000000E+00   1.61346326533622E-15   4.28815000016521E-23
      3.93637670930180E-09   3.93637832276511E-09  -8.88351692582153E-19  -2.06362173777453E-01  -2.06362173777502E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99507423438648E-11   0.00000000000000E+00   4.99507423438648E-11
      3.86469033627654E-18  -2.06362172933430E-01  -2.05106265609729E-01   0.00000000000000E+00   1.08423387971912E-13
     -9.72793232863741E-23  -3.98643748849685E-09  -3.98632906510898E-09  -2.97633864369439E-18
      1.15831867338736E-09
      0.00000000000000E+00  -3.93802679724712E-12   0.00000000000000E+00   1.44888618565650E-15   4.37527352566744E-23
      3.93805574625462E-09   3.93805719514085E-09  -8.88519836887518E-19  -2.06194277253081E-01  -2.06194277253130E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90459286536962E-11   0.00000000000000E+00   4.90459286536962E-11
      3.86714263270923E-18  -2.06194275449299E-01  -2.04938124151530E-01   0.00000000000000E+00   1.06874974865831E-13
     -9.72555386020936E-23  -3.98720999876932E-09  -3.98710312379455E-09  -2.97862279582171E-18
      1.20831867338736E-09
      0.00000000000000E+00  -3.93968000251686E-12   0.00000000000000E+00   1.55546063355718E-15   4.46160931524405E-23
      3.93970242136039E-09   3.93970397682106E-09  -8.88679968419691E-19  -2.06029615338808E-01  -2.06029615338856E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81705197915363E-11   0.00000000000000E+00   4.81705197915363E-11
      3.86955115869881E-18  -2.06029612671582E-01  -2.04773218332167E-01   0.00000000000000E+00   1.05101488729486E-13
     -9.72320849161193E-23  -3.98797959810125E-09  -3.98787449661261E-09  -2.98087119027912E-18
      1.25831867338736E-09
      0.00000000000000E+00  -3.94133320778660E-12   0.00000000000000E+00   1.45954658007785E-15   4.54717178721032E-23
      3.94131784339114E-09   3.94131930293777E-09  -8.88832852514371E-19  -2.05868071227521E-01  -2.05868071227568E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73225308264017E-11   0.00000000000000E+00   4.73225308264017E-11
      3.87191728524013E-18  -2.05868068324050E-01  -2.04611432150785E-01   0.00000000000000E+00   1.03555845070366E-13
     -9.72089568731369E-23  -3.98874538960909E-09  -3.98864183376412E-09  -2.98308443272575E-18
      1.30831867338736E-09
      0.00000000000000E+00  -3.94298641305633E-12   0.00000000000000E+00   1.49832886700802E-15   4.63197276167095E-23
      3.94290308193729E-09   3.94290458026621E-09  -8.88979170523297E-19  -2.05709537103396E-01  -2.05709537103442E-01
      0.00000000000000E+00   0.00000000000000E+00   4.65000643743399E-11   0.00000000000000E+00   4.65000643743399E-11
      3.87424228845884E-18  -2.05709535257175E-01  -2.04452658719308E-01   0.00000000000000E+00   1.01916798514360E-13
     -9.71861490570470E-23  -3.98950656143902E-09  -3.98940464464060E-09  -2.98526311793555E-18
      1.35831867338736E-09
      0.00000000000000E+00  -3.94445592885165E-12   0.00000000000000E+00   1.44375106563705E-15   4.71602383835714E-23
      3.94445911449073E-09   3.94446055824185E-09  -8.89119531052095E-19  -2.05553912630026E-01  -2.05553912630072E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57014861793508E-11   0.00000000000000E+00   4.57014861793508E-11
      3.87652736276781E-18  -2.05553913714360E-01  -2.04296798487485E-01   0.00000000000000E+00   1.00393720375411E-13
     -9.71636565487284E-23  -3.99026243814145E-09  -3.99016204442117E-09  -2.98740783171572E-18
      1.40831867338736E-09
      0.00000000000000E+00  -3.94601728938418E-12   0.00000000000000E+00   1.44310999850735E-15   4.79933471286121E-23
      3.94598692463273E-09   3.94598836774277E-09  -8.89254475324287E-19  -2.05401105091007E-01  -2.05401105091052E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49252149556534E-11   0.00000000000000E+00   4.49252149556534E-11
      3.87877362351559E-18  -2.05401111094179E-01  -2.04143759042735E-01   0.00000000000000E+00   9.88547158062705E-14
     -9.71414742936090E-23  -3.99101243741414E-09  -3.99091358269843E-09  -2.98951914819131E-18
      1.45831867338736E-09
      0.00000000000000E+00  -3.94748680517950E-12   0.00000000000000E+00   1.41300319201154E-15   4.88191498489149E-23
      3.94748745777344E-09   3.94748887077668E-09  -8.89384485839350E-19  -2.05251028259513E-01  -2.05251028259557E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41698693241474E-11   0.00000000000000E+00   4.41698693241474E-11
      3.88098211698180E-18  -2.05251040356749E-01  -2.03993453482026E-01   0.00000000000000E+00   9.73664958070873E-14
     -9.71195975412548E-23  -3.99175610659655E-09  -3.99165874010084E-09  -2.99159763114245E-18
      1.50831867338736E-09
      0.00000000000000E+00  -3.94904816571203E-12   0.00000000000000E+00   1.39061441196719E-15   4.96377287905448E-23
      3.94896169167149E-09   3.94896308228596E-09  -8.89509990943844E-19  -2.05103602440866E-01  -2.05103602440909E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34341062096405E-11   0.00000000000000E+00   4.34341062096405E-11
      3.88315382229228E-18  -2.05103619682645E-01  -2.03845800101482E-01   0.00000000000000E+00   9.59068395539271E-14
     -9.70980213288669E-23  -3.99249309533505E-09  -3.99239718849560E-09  -2.99364383134844E-18
      1.55831867338736E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00   1.37461741795317E-15   5.04491654435344E-23
      3.95041056663428E-09   3.95041194125175E-09  -8.89631372105697E-19  -2.04958753343325E-01  -2.04958753343368E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27167656041648E-11   0.00000000000000E+00   4.27167656041648E-11
      3.88528966057249E-18  -2.04958771283765E-01  -2.03700721181777E-01   0.00000000000000E+00   9.44619043169218E-14
     -9.70767409337814E-23  -3.99322316876014E-09  -3.99312870685592E-09  -2.99565828846679E-18
      1.60831867338736E-09
      0.00000000000000E+00  -3.95189535256546E-12   0.00000000000000E+00   1.34130623687488E-15   5.12535294564416E-23
      3.95183496271710E-09   3.95183630402339E-09  -8.89748968979815E-19  -2.04816411478945E-01  -2.04816411478987E-01
      0.00000000000000E+00   0.00000000000000E+00   4.20167768770990E-11   0.00000000000000E+00   4.20167768770990E-11
      3.88739049941634E-18  -2.04816421483589E-01  -2.03558143106861E-01   0.00000000000000E+00   9.30691096170438E-14
     -9.70557514605388E-23  -3.99394615001003E-09  -3.99385308090051E-09  -2.99764153043653E-18
      1.65831867338736E-09
      0.00000000000000E+00  -3.95327302362357E-12   0.00000000000000E+00   1.33277540235734E-15   5.20508863282648E-23
      3.95323555434559E-09   3.95323688712104E-09  -8.89863086841797E-19  -2.04676510444873E-01  -2.04676510444914E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13333090191837E-11   0.00000000000000E+00   4.13333090191837E-11
      3.88945716486731E-18  -2.04676500461171E-01  -2.03417996104779E-01   0.00000000000000E+00   9.16711962093369E-14
     -9.70350484313427E-23  -3.99466186733632E-09  -3.99457019614020E-09  -2.99959407802551E-18
      1.70831867338737E-09
      0.00000000000000E+00  -3.95465069468169E-12   0.00000000000000E+00   1.29442315221900E-15   5.28412867709652E-23
      3.95461271694580E-09   3.95461401136900E-09  -8.89974002424339E-19  -2.04538985602776E-01  -2.04538985602817E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06657060808796E-11   0.00000000000000E+00   4.06657060808796E-11
      3.89149045017135E-18  -2.04538943444460E-01  -2.03280215492321E-01   0.00000000000000E+00   9.03334854309451E-14
     -9.70146276114682E-23  -3.99537005093521E-09  -3.99527971744988E-09  -3.00151644774701E-18
      1.75831867338737E-09
      0.00000000000000E+00  -3.95593652100259E-12   0.00000000000000E+00   1.28868683696329E-15   5.36247717357429E-23
      3.95596640738610E-09   3.95596769607299E-09  -8.90081970484980E-19  -2.04403772342531E-01  -2.04403772342571E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00135854247498E-11   0.00000000000000E+00   4.00135854247498E-11
      3.89349112944259E-18  -2.04403691847236E-01  -2.03144742817169E-01   0.00000000000000E+00   8.89766652381281E-14
     -9.69944857123508E-23  -3.99607025816288E-09  -3.99598128149774E-09  -3.00340915895761E-18
      1.80831867338737E-09
      0.00000000000000E+00  -3.95731419206070E-12   0.00000000000000E+00   1.24746402676074E-15   5.44013655042481E-23
      3.95729618517284E-09   3.95729743263692E-09  -8.90187227466545E-19  -2.04270805488041E-01  -2.04270805488080E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93766916527534E-11   0.00000000000000E+00   3.93766916527534E-11
      3.89545996402523E-18  -2.04270694915158E-01  -2.03011527544689E-01   0.00000000000000E+00   8.76762116990939E-14
     -9.69746202316683E-23  -3.99676180050129E-09  -3.99667412428969E-09  -3.00527273655868E-18
      1.85831867338737E-09
      0.00000000000000E+00  -3.95860001838161E-12   0.00000000000000E+00   1.24162818036634E-15   5.51710847691700E-23
      3.95860138995115E-09   3.95860263157938E-09  -8.90289992456630E-19  -2.04140019892916E-01  -2.04140019892955E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87548217962288E-11   0.00000000000000E+00   3.87548217962288E-11
      3.89739770511504E-18  -2.04139910169121E-01  -2.02880527467499E-01   0.00000000000000E+00   8.63444699460605E-14
     -9.69550298095179E-23  -3.99744379784547E-09  -3.99735745337562E-09  -3.00710771265841E-18
      1.90831867338736E-09
      0.00000000000000E+00  -3.95988584470252E-12   0.00000000000000E+00   1.19849655687434E-15   5.59339441784817E-23
      3.95988163220077E-09   3.95988283069738E-09  -8.90390461908138E-19  -2.04011353855147E-01  -2.04011353855185E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81474787014502E-11   0.00000000000000E+00   3.81474787014502E-11
      3.89930507905011E-18  -2.04011302289964E-01  -2.02751707546021E-01   0.00000000000000E+00   8.50637697768085E-14
     -9.69357133989352E-23  -3.99811537316849E-09  -3.99803030939881E-09  -3.00891461714197E-18
      1.95831867338736E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00   1.19300450051561E-15   5.66899766940326E-23
      3.96113748816291E-09   3.96113868116746E-09  -8.90488799474875E-19  -2.03884754797098E-01  -2.03884754797136E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75536174109078E-11   0.00000000000000E+00   3.75536174109078E-11
      3.90118275992065E-18  -2.03884838348995E-01  -2.02625034998620E-01   0.00000000000000E+00   8.37512837620963E-14
     -9.69166695131891E-23  -3.99877604986203E-09  -3.99869229857836E-09  -3.01069396044578E-18
      2.00831867338737E-09
      0.00000000000000E+00  -3.96236565260712E-12   0.00000000000000E+00   1.15255000678510E-15   5.74392523538624E-23
      3.96237133724290E-09   3.96237248979296E-09  -8.90585121423382E-19  -2.03760187015332E-01  -2.03760187015369E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69712933416729E-11   0.00000000000000E+00   3.69712933416729E-11
      3.90303132458774E-18  -2.03760479678255E-01  -2.02500471020080E-01   0.00000000000000E+00   8.25029343667878E-14
     -9.68978942292302E-23  -3.99942628606894E-09  -3.99934378313467E-09  -3.01244620316436E-18
      2.05831867338737E-09
      0.00000000000000E+00  -3.96355963419082E-12   0.00000000000000E+00   1.15187892486069E-15   5.81818985458165E-23
      3.96358793354856E-09   3.96358908542755E-09  -8.90679484203132E-19  -2.03637638407933E-01  -2.03637638407969E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63976742171379E-11   0.00000000000000E+00   3.63976742171379E-11
      3.90485120829859E-18  -2.03638170466045E-01  -2.02377959192172E-01   0.00000000000000E+00   8.12541442930079E-14
     -9.68793795880742E-23  -4.00006801378882E-09  -3.99998675964463E-09  -3.01417172409546E-18
      2.10831867338737E-09
      0.00000000000000E+00  -3.96484546051172E-12   0.00000000000000E+00   1.12504124145304E-15   5.89181033453260E-23
      3.96479429142072E-09   3.96479541646202E-09  -8.90771882061976E-19  -2.03517122458285E-01  -2.03517122458321E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58293714936080E-11   0.00000000000000E+00   3.58293714936080E-11
      3.90664267687327E-18  -2.03517827092893E-01  -2.02257414752672E-01   0.00000000000000E+00   8.01088280104028E-14
     -9.68611119353896E-23  -4.00070489678357E-09  -4.00062478795566E-09  -3.01587079481130E-18
      2.15831867338737E-09
      0.00000000000000E+00  -3.96603944209542E-12   0.00000000000000E+00   1.13285408287023E-15   5.96480914617299E-23
      3.96599822894062E-09   3.96599936179476E-09  -8.90862267277026E-19  -2.03398669440251E-01  -2.03398669440286E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52635375713756E-11   0.00000000000000E+00   3.52635375713756E-11
      3.90840585375184E-18  -2.03399333045646E-01  -2.02138719621888E-01   0.00000000000000E+00   7.90200862265014E-14
     -9.68430725589225E-23  -4.00134191945229E-09  -4.00126289936616E-09  -3.01754358647482E-18
      2.20831867338737E-09
      0.00000000000000E+00  -3.96723342367912E-12   0.00000000000000E+00   1.12581333909332E-15   6.03720551596308E-23
      3.96720529685104E-09   3.96720642266444E-09  -8.90950601333564E-19  -2.03282302811565E-01  -2.03282302811600E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46994881228988E-11   0.00000000000000E+00   3.46994881228988E-11
      3.91014082815799E-18  -2.03282548067570E-01  -2.02021732010843E-01   0.00000000000000E+00   7.80523726768185E-14
     -9.68252407910543E-23  -4.00198396315991E-09  -4.00190591078733E-09  -3.01919022682443E-18
      2.25831867338737E-09
      0.00000000000000E+00  -3.96842740526282E-12   0.00000000000000E+00   1.13161092710612E-15   6.10900471668845E-23
      3.96841413661935E-09   3.96841526823034E-09  -8.91036939985872E-19  -2.03167999193344E-01  -2.03167999193379E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41407911166019E-11   0.00000000000000E+00   3.41407911166019E-11
      3.91184786771382E-18  -2.03167337777070E-01  -2.01906316843705E-01   0.00000000000000E+00   7.71378527767732E-14
     -9.68076015391875E-23  -4.00263319719960E-09  -4.00255605934692E-09  -3.02081092772795E-18
      2.30831867338737E-09
      0.00000000000000E+00  -3.96962138684651E-12   0.00000000000000E+00   1.11753514651024E-15   6.18018387882585E-23
      3.96961144939115E-09   3.96961256692636E-09  -8.91121536566270E-19  -2.03055639207879E-01  -2.03055639207912E-01
      0.00000000000000E+00   0.00000000000000E+00   3.35968309025306E-11   0.00000000000000E+00   3.35968309025306E-11
      3.91352770925894E-18  -2.03053627288039E-01  -2.01792400471565E-01   0.00000000000000E+00   7.62307794861672E-14
     -9.67901558158352E-23  -4.00328562860830E-09  -4.00320939782891E-09  -3.02240617269268E-18
      2.35831867338737E-09
      0.00000000000000E+00  -3.97072352369300E-12   0.00000000000000E+00   1.08462000417177E-15   6.25068175030420E-23
      3.97076867578532E-09   3.97076976040538E-09  -8.91204928692036E-19  -2.02944965549456E-01  -2.02944965549489E-01
      0.00000000000000E+00   0.00000000000000E+00   3.30828968637468E-11   0.00000000000000E+00   3.30828968637468E-11
      3.91518185410213E-18  -2.02941470913582E-01  -2.01680041392872E-01   0.00000000000000E+00   7.51820693283360E-14
     -9.67729327544163E-23  -4.00392783933833E-09  -4.00385265726910E-09  -3.02397692541010E-18
      2.40831867338737E-09
      0.00000000000000E+00  -3.97182566053949E-12   0.00000000000000E+00   1.00132224057763E-15   6.32039724678255E-23
      3.97184373845066E-09   3.97184473977297E-09  -8.91287947980777E-19  -2.02835577057125E-01  -2.02835577057158E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26171700784306E-11   0.00000000000000E+00   3.26171700784306E-11
      3.91681271260606E-18  -2.02831116627335E-01  -2.01569495114324E-01   0.00000000000000E+00   7.38555559612432E-14
     -9.67559969531247E-23  -4.00453576540729E-09  -4.00446190985142E-09  -3.02552476462528E-18
      2.45831867338737E-09
      0.00000000000000E+00  -3.97274410791157E-12   0.00000000000000E+00   9.21323547655776E-16   6.38920945966799E-23
      3.97279118680950E-09   3.97279210813311E-09  -8.91371583398934E-19  -2.02726992065110E-01  -2.02726992065142E-01
      0.00000000000000E+00   0.00000000000000E+00   3.22137640323749E-11   0.00000000000000E+00   3.22137640323749E-11
      3.91842340080767E-18  -2.02723027082215E-01  -2.01461234162756E-01   0.00000000000000E+00   7.20459532135783E-14
     -9.67394444991812E-23  -4.00507791811862E-09  -4.00500587216550E-09  -3.02705181740874E-18
      2.50831867338737E-09
      0.00000000000000E+00  -3.97366255528364E-12   0.00000000000000E+00   7.33030332363113E-16   6.45702511425534E-23
      3.97358289506310E-09   3.97358362809350E-09  -8.91456641761998E-19  -2.02618808698924E-01  -2.02618808698955E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18717276406789E-11   0.00000000000000E+00   3.18717276406789E-11
      3.92001698718970E-18  -2.02617808754102E-01  -2.01355874169837E-01   0.00000000000000E+00   6.98600658105036E-14
     -9.67233788245299E-23  -4.00552521579990E-09  -4.00545535573419E-09  -3.02856034542771E-18
      2.55831867338737E-09
      0.00000000000000E+00  -3.97430546844410E-12   0.00000000000000E+00   7.24494453849421E-16   6.52385140844294E-23
      3.97423770571284E-09   3.97423843020736E-09  -8.91543204176227E-19  -2.02510963770781E-01  -2.02510963770812E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15623942919357E-11   0.00000000000000E+00   3.15623942919357E-11
      3.92159510690430E-18  -2.02516006622479E-01  -2.01253963195453E-01   0.00000000000000E+00   6.72260355183973E-14
     -9.67078624028657E-23  -4.00586805053467E-09  -4.00580082449925E-09  -3.03005190272808E-18
      2.60831867338737E-09
      0.00000000000000E+00  -3.97485653686734E-12   0.00000000000000E+00   5.47125652251245E-16   6.58988657900806E-23
      3.97485252837880E-09   3.97485307550452E-09  -8.91629986557226E-19  -2.02404040233127E-01  -2.02404040233158E-01
      0.00000000000000E+00   0.00000000000000E+00   3.12200308613453E-11   0.00000000000000E+00   3.12200308613453E-11
      3.92315610844737E-18  -2.02417752992104E-01  -2.01155623698324E-01   0.00000000000000E+00   6.50935933155223E-14
     -9.66928473376146E-23  -4.00613819995909E-09  -4.00607310636587E-09  -3.03152612189014E-18
      2.65831867338737E-09
      0.00000000000000E+00  -3.97559129476500E-12   0.00000000000000E+00   7.22474855530651E-16   6.65558045640152E-23
      3.97561999316491E-09   3.97562071563983E-09  -8.91713842985845E-19  -2.02299510471457E-01  -2.02299510471488E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07435527674918E-11   0.00000000000000E+00   3.07435527674918E-11
      3.92469328608574E-18  -2.02322327486429E-01  -2.01060106429337E-01   0.00000000000000E+00   6.38266163834489E-14
     -9.66781033283584E-23  -4.00642809502365E-09  -4.00636426840736E-09  -3.03297944309990E-18
      2.70831867338737E-09
      0.00000000000000E+00  -3.97678527634870E-12   0.00000000000000E+00   1.14553202591540E-15   6.72162945315197E-23
      3.97681219578433E-09   3.97681334131643E-09  -8.91789802893813E-19  -2.02199729232097E-01  -2.02199729232128E-01
      0.00000000000000E+00   0.00000000000000E+00   3.00178750730960E-11   0.00000000000000E+00   3.00178750730960E-11
      3.92619417983940E-18  -2.02227774533857E-01  -2.00965406325582E-01   0.00000000000000E+00   6.46380191886207E-14
     -9.66631767684896E-23  -4.00689585440862E-09  -4.00683121638952E-09  -3.03440437694558E-18
      2.75831867338737E-09
      0.00000000000000E+00  -3.97871401583006E-12   0.00000000000000E+00   1.84504538288882E-15   6.78882721947784E-23
      3.97870951235648E-09   3.97871135740193E-09  -8.91852073357371E-19  -2.02107468500653E-01  -2.02107468500682E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89610604285079E-11   0.00000000000000E+00   2.89610604285079E-11
      3.92764223286082E-18  -2.02130827897777E-01  -2.00868194627113E-01   0.00000000000000E+00   6.83053978268593E-14
     -9.66474302672571E-23  -4.00774072322815E-09  -4.00767241783041E-09  -3.03579015950345E-18
      2.80831867338737E-09
      0.00000000000000E+00  -3.98146935794628E-12   0.00000000000000E+00   3.04182508865895E-15   6.85774133360097E-23
      3.98146339014241E-09   3.98146643196757E-09  -8.91896331116649E-19  -2.02024835301442E-01  -2.02024835301470E-01
      0.00000000000000E+00   0.00000000000000E+00   2.75949231298063E-11   0.00000000000000E+00   2.75949231298063E-11
      3.92902197901732E-18  -2.02027444288877E-01  -2.00764373497295E-01   0.00000000000000E+00   7.45419517217760E-14
     -9.66302099937075E-23  -4.00913589704902E-09  -4.00906135509739E-09  -3.03712564790067E-18
      2.85831867338737E-09
      0.00000000000000E+00  -3.98486761322296E-12   0.00000000000000E+00   3.50355507406612E-15   6.92821624029605E-23
      3.98490765662775E-09   3.98491116018290E-09  -8.91923234682305E-19  -2.01951597496684E-01  -2.01951597496710E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61232139469490E-11   0.00000000000000E+00   2.61232139469490E-11
      3.93032813971466E-18  -2.01914193238252E-01  -2.00650500725904E-01   0.00000000000000E+00   8.29164931551933E-14
     -9.66111665667526E-23  -4.01111729062294E-09  -4.01103437412989E-09  -3.03840490503236E-18
      2.88331867338737E-09
      0.00000000000000E+00  -3.98661266322991E-12   0.00000000000000E+00  -1.72554702717673E-15   6.96358405056511E-23
      3.98663765109376E-09   3.98663592554680E-09  -8.91934524037311E-19  -2.01916323495335E-01  -2.01916323495361E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55175562292824E-11   0.00000000000000E+00   2.55175562292824E-11
      3.93096607862039E-18  -2.01854743960299E-01  -2.00590697171903E-01   0.00000000000000E+00   9.20923276298161E-14
     -9.65291723506221E-23  -4.01224557410355E-09  -4.01215348177602E-09  -3.03903155458308E-18
      2.89175617338737E-09
      0.00000000000000E+00  -3.98734742112757E-12   0.00000000000000E+00   4.09541818910561E-15   6.97563630388335E-23
      3.98733893115973E-09   3.98734302657799E-09  -8.91937186794771E-19  -2.01904988184895E-01  -2.01904988184920E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51554596517201E-11   0.00000000000000E+00   2.51554596517201E-11
      3.93117832781121E-18  -2.01834491634017E-01  -2.00570337781233E-01   0.00000000000000E+00   8.86983103971106E-14
     -9.65928586443493E-23  -4.01258718453995E-09  -4.01249848622965E-09  -3.03924114101644E-18
      2.90314679838737E-09
      0.00000000000000E+00  -3.98817402376243E-12   0.00000000000000E+00   3.81773184720484E-15   6.99198950824565E-23
      3.98822067276951E-09   3.98822449050142E-09  -8.91940165505337E-19  -2.01890041146016E-01  -2.01890041146041E-01
      0.00000000000000E+00   0.00000000000000E+00   2.48354910928203E-11   0.00000000000000E+00   2.48354910928203E-11
      3.93146121957693E-18  -2.01806490384149E-01  -2.00542159620311E-01   0.00000000000000E+00   9.03148835082802E-14
     -9.65962135918127E-23  -4.01315029647753E-09  -4.01305998159412E-09  -3.03952105407159E-18
      2.91852414213737E-09
      0.00000000000000E+00  -3.98945985008334E-12   0.00000000000000E+00   3.82485858444078E-15   7.01408033213333E-23
      3.98941249033425E-09   3.98941631519291E-09  -8.91943371820445E-19  -2.01870372148831E-01  -2.01870372148856E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44459032116602E-11   0.00000000000000E+00   2.44459032116602E-11
      3.93183713263390E-18  -2.01767470391441E-01  -2.00502886865648E-01   0.00000000000000E+00   9.26887767084812E-14
     -9.65866183371449E-23  -4.01395490718126E-09  -4.01386221840465E-09  -3.03989376081346E-18
      2.93928355619987E-09
      0.00000000000000E+00  -3.99092936587866E-12   0.00000000000000E+00   3.67431275947177E-15   7.04377132160712E-23
      3.99095780593620E-09   3.99096148024903E-09  -8.91947266805681E-19  -2.01844252865074E-01  -2.01844252865098E-01
      0.00000000000000E+00   0.00000000000000E+00   2.40238873376603E-11   0.00000000000000E+00   2.40238873376603E-11
      3.93233585445853E-18  -2.01712691141588E-01  -2.00447753742725E-01   0.00000000000000E+00   9.52358965607069E-14
     -9.65775440671472E-23  -4.01508060348314E-09  -4.01498536758668E-09  -3.04038858765285E-18
      2.96730876518424E-09
      0.00000000000000E+00  -3.99267441588560E-12   0.00000000000000E+00   3.03694971569544E-15   7.08303081112997E-23
      3.99267722548901E-09   3.99268026243880E-09  -8.91955788294637E-19  -2.01807866876298E-01  -2.01807866876322E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37785063019168E-11   0.00000000000000E+00   2.37785063019168E-11
      3.93300225206698E-18  -2.01635774979417E-01  -2.00370373353478E-01   0.00000000000000E+00   9.63541846516628E-14
     -9.65651791793476E-23  -4.01655512292527E-09  -4.01645876874071E-09  -3.04104646377234E-18
      3.00514279731315E-09
      0.00000000000000E+00  -3.99350101852047E-12   0.00000000000000E+00   1.01718925156069E-15   7.13234023473190E-23
      3.99346864358821E-09   3.99346966077753E-09  -8.91988399574819E-19  -2.01749488983193E-01  -2.01749488983218E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44373340567796E-11   0.00000000000000E+00   2.44373340567796E-11
      3.93392681494883E-18  -2.01531541811339E-01  -2.00265683869427E-01   0.00000000000000E+00   9.03599287046701E-14
     -9.65495006083743E-23  -4.01799735476291E-09  -4.01790699483430E-09  -3.04193841537401E-18
      3.05514279731315E-09
      0.00000000000000E+00  -3.98945985008334E-12   0.00000000000000E+00  -3.79053945135180E-15   7.18456759373378E-23
      3.98948926407344E-09   3.98948547353406E-09  -8.92114527172450E-19  -2.01634043029044E-01  -2.01634043029072E-01
      0.00000000000000E+00   0.00000000000000E+00   2.78713363948563E-11   0.00000000000000E+00   2.78713363948563E-11
      3.93532038176857E-18  -2.01415450000971E-01  -2.00149765400751E-01   0.00000000000000E+00   6.14005173004921E-14
     -9.65352081968035E-23  -4.01741821044610E-09  -4.01735680992890E-09  -3.04320585459613E-18
      3.10514279731315E-09
      0.00000000000000E+00  -3.97862217109285E-12   0.00000000000000E+00  -1.03590759982522E-14   7.21801984645659E-23
      3.97866962202790E-09   3.97865926295197E-09  -8.92366892928605E-19  -2.01459312253771E-01  -2.01459312253805E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41111509559103E-11   0.00000000000000E+00   3.41111509559103E-11
      3.93702593931637E-18  -2.01352111468013E-01  -2.00087871860558E-01   0.00000000000000E+00   7.88542423192068E-15
     -9.65328383532622E-23  -4.01277829933208E-09  -4.01277041390794E-09  -3.04465904638777E-18
      3.15514279731315E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00  -1.69867516941496E-14   7.23113062905213E-23
      3.96114849768085E-09   3.96113151092923E-09  -8.92760855050688E-19  -2.01217273970367E-01  -2.01217273970409E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21611333831341E-11   0.00000000000000E+00   4.21611333831341E-11
      3.93913399598553E-18  -2.01372865898840E-01  -2.00111612295798E-01   0.00000000000000E+00  -6.42086656612111E-14
     -9.65465975865266E-23  -4.00322843564656E-09  -4.00329264431231E-09  -3.04637314093484E-18
      3.20514279731315E-09
      0.00000000000000E+00  -3.94059844988894E-12   0.00000000000000E+00  -2.04033274836400E-14   7.23122527328147E-23
      3.94063308105621E-09   3.94061267772880E-09  -8.93251594668088E-19  -2.00928381329559E-01  -2.00928381329608E-01
      0.00000000000000E+00   0.00000000000000E+00   4.92219029265632E-11   0.00000000000000E+00   4.92219029265632E-11
      3.94159509113185E-18  -2.01493354680734E-01  -2.00236340979456E-01   0.00000000000000E+00  -1.34178446977690E-13
     -9.65760993968838E-23  -3.98970040220831E-09  -3.98983458065539E-09  -3.04834349646377E-18
      3.25514279731315E-09
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00  -1.43741560323977E-14   7.23843915329462E-23
      3.92553961388598E-09   3.92552523973002E-09  -8.93704647566453E-19  -2.00655910047912E-01  -2.00655910047963E-01
      0.00000000000000E+00   0.00000000000000E+00   5.05838692115104E-11   0.00000000000000E+00   5.05838692115104E-11
      3.94412428459243E-18  -2.01692240652478E-01  -2.00439551483367E-01   0.00000000000000E+00  -1.66203707635559E-13
     -9.66125775196655E-23  -3.97594290523375E-09  -3.97610910894148E-09  -3.05041963702597E-18
      3.30514279731315E-09
      0.00000000000000E+00  -3.92875047878916E-12   0.00000000000000E+00   6.04977201166035E-15   7.28640058571197E-23
      3.92868423265527E-09   3.92869028242735E-09  -8.93888070336207E-19  -2.00510180739400E-01  -2.00510180739440E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04477633438939E-11   0.00000000000000E+00   4.04477633438939E-11
      3.94614667275962E-18  -2.01890803958426E-01  -2.00640311865527E-01   0.00000000000000E+00  -1.11279857049004E-13
     -9.66363169877708E-23  -3.96902676591411E-09  -3.96913804577125E-09  -3.05225860242341E-18
      3.35514279731315E-09
      0.00000000000000E+00  -3.96456992630010E-12   0.00000000000000E+00   8.23496151294314E-14   7.41679802321127E-23
      3.96451306517419E-09   3.96459541478939E-09  -8.93510134352189E-19  -2.00631115372004E-01  -2.00631115372018E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40211440742121E-11   0.00000000000000E+00   1.40211440742121E-11
      3.94684772996333E-18  -2.01944108532131E-01  -2.00690644080870E-01   0.00000000000000E+00   3.59904401742839E-14
     -9.66174550412321E-23  -3.97865254930370E-09  -3.97861655886363E-09  -3.05333759561114E-18
      3.40514279731315E-09
      0.00000000000000E+00  -4.04337271082416E-12   0.00000000000000E+00   1.19638583582978E-13   7.66518477345302E-23
      4.04323347052439E-09   4.04335310910805E-09  -8.92324112239557E-19  -2.01138728131220E-01  -2.01138728131191E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91451258979479E-11   0.00000000000000E+00  -2.91451258979479E-11
      3.94539047366844E-18  -2.01655771786065E-01  -2.00391092411696E-01   0.00000000000000E+00   3.81772777258227E-13
     -9.65221661798871E-23  -4.01458975598724E-09  -4.01420798321008E-09  -3.05306636142888E-18
      3.45514279731315E-09
      0.00000000000000E+00  -4.16240349024511E-12   0.00000000000000E+00   1.19554042251669E-13   8.03790936756347E-23
      4.16232818627006E-09   4.16244774031239E-09  -8.90289619722981E-19  -2.02056360122853E-01  -2.02056360122772E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.16459551031230E-11   0.00000000000000E+00  -8.16459551031230E-11
      3.94130817591328E-18  -2.00830313981011E-01  -1.99544641108327E-01   0.00000000000000E+00   8.61901635754766E-13
     -9.63275325715853E-23  -4.08166368684491E-09  -4.08080178520925E-09  -3.05101855619030E-18
      3.50514279731315E-09
      0.00000000000000E+00  -4.29658865130531E-12   0.00000000000000E+00   1.64558331075617E-13   8.48195123189202E-23
      4.29648442960495E-09   4.29664898793611E-09  -8.87757195178359E-19  -2.03222558069061E-01  -2.03222558068936E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25408893436862E-10   0.00000000000000E+00  -1.25408893436862E-10
      3.93503773124144E-18  -1.99374117621502E-01  -1.98059960799005E-01   0.00000000000000E+00   1.23274736034471E-12
     -9.60397274129390E-23  -4.17247284185952E-09  -4.17124009449927E-09  -3.04728053606308E-18
      3.55514279731315E-09
      0.00000000000000E+00  -4.39017843851978E-12   0.00000000000000E+00   9.43709582416515E-14   8.85673474712061E-23
      4.39000254411878E-09   4.39009691507711E-09  -8.85603294865918E-19  -2.04225686839085E-01  -2.04225686838953E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31469725489224E-10   0.00000000000000E+00  -1.31469725489224E-10
      3.92846424496698E-18  -1.97441697848758E-01  -1.96099999238191E-01   0.00000000000000E+00   1.39886160077934E-12
     -9.57176786808221E-23  -4.26002605118857E-09  -4.25862718958789E-09  -3.04286095010106E-18
      3.60514279731315E-09
      0.00000000000000E+00  -4.35748171207390E-12   0.00000000000000E+00  -3.16998703017364E-14   8.92876001119538E-23
      4.35756555901791E-09   4.35753385914770E-09  -8.85249069240073E-19  -2.04391180679326E-01  -2.04391180679262E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.34386966997277E-11   0.00000000000000E+00  -6.34386966997277E-11
      3.92529231013199E-18  -1.95595097158369E-01  -1.94242223057336E-01   0.00000000000000E+00   9.81615537021181E-13
     -9.54893834347542E-23  -4.29507677798492E-09  -4.29409516244800E-09  -3.04004324089192E-18
      3.65514279731315E-09
      0.00000000000000E+00  -4.10481684001599E-12   0.00000000000000E+00  -2.52365659529315E-13   8.42171024267449E-23
      4.10509948908476E-09   4.10484712342531E-09  -8.88506035332804E-19  -2.02847953673405E-01  -2.02847953673516E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11581955246811E-10   0.00000000000000E+00   1.11581955246811E-10
      3.93087140789433E-18  -1.94852960759616E-01  -1.93524554411255E-01   0.00000000000000E+00  -2.73877838401152E-13
     -9.55531133249969E-23  -4.21615520083361E-09  -4.21642907867211E-09  -3.04236537256153E-18
      3.70514279731315E-09
      0.00000000000000E+00  -3.58102630372147E-12   0.00000000000000E+00  -5.25243368658532E-13   7.15478074360930E-23
      3.58154630622484E-09   3.58102106285625E-09  -8.97114821745992E-19  -1.98739877042744E-01  -1.98739877043143E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98536923618560E-10   0.00000000000000E+00   3.98536923618560E-10
      3.95079825407526E-18  -1.96440413130975E-01  -1.95186632991913E-01   0.00000000000000E+00  -2.51784124315072E-12
     -9.61311980699505E-23  -3.97704014523157E-09  -3.97955798647482E-09  -3.05368343232927E-18
      3.75514279731315E-09
      0.00000000000000E+00  -2.85122802187046E-12   0.00000000000000E+00  -7.35178571359716E-13   5.23912160749431E-23
      2.85191782862692E-09   2.85118265005561E-09  -9.11755376004232E-19  -1.91695855909180E-01  -1.91695855909918E-01
      0.00000000000000E+00   0.00000000000000E+00   7.38298733125430E-10   0.00000000000000E+00   7.38298733125430E-10
      3.98771319073153E-18  -2.01140152934071E-01  -2.00009267500262E-01   0.00000000000000E+00  -5.52144975732015E-12
     -9.73546099444621E-23  -3.58395993342361E-09  -3.58948138318103E-09  -3.07595781472730E-18
      3.80514279731315E-09
      0.00000000000000E+00  -2.13493091638896E-12   0.00000000000000E+00  -7.27071069775859E-13   3.17787804284985E-23
      2.13565666573953E-09   2.13492959466978E-09  -9.30392192688732E-19  -1.82640207131726E-01  -1.82640207132711E-01
      0.00000000000000E+00   0.00000000000000E+00   9.85484054432881E-10   0.00000000000000E+00   9.85484054432881E-10
      4.03698739345317E-18  -2.08604147745927E-01  -2.07621044280634E-01   0.00000000000000E+00  -8.31976750378357E-12
     -9.90978477678011E-23  -3.11209388159878E-09  -3.12041364910267E-09  -3.10659520076444E-18
      3.85514279731315E-09
      0.00000000000000E+00  -1.74339680167327E-12   0.00000000000000E+00  -4.04823690940740E-13   1.71025812677212E-23
      1.74379616327986E-09   1.74339133958893E-09  -9.46570536175066E-19  -1.74672489855187E-01  -1.74672489856127E-01
      0.00000000000000E+00   0.00000000000000E+00   9.40154880821409E-10   0.00000000000000E+00   9.40154880821409E-10
      4.08399513749425E-18  -2.17345132210470E-01  -2.16499667671572E-01   0.00000000000000E+00  -9.00996835804168E-12
     -1.00873038388303E-22  -2.67453625205222E-09  -2.68354622041036E-09  -3.13742460131918E-18
      3.90514279731315E-09
      0.00000000000000E+00  -1.93470938927655E-12   0.00000000000000E+00   1.84197594199759E-13   1.53573066557268E-23
      1.93455428616537E-09   1.93473848375959E-09  -9.50407287264704E-19  -1.72641517274971E-01  -1.72641517275438E-01
      0.00000000000000E+00   0.00000000000000E+00   4.67504689328245E-10   0.00000000000000E+00   4.67504689328245E-10
      4.10737037196066E-18  -2.25342380354583E-01  -2.24585546582793E-01   0.00000000000000E+00  -5.61025638081171E-12
     -1.01932868475256E-22  -2.39663291670695E-09  -2.40224317308786E-09  -3.15696308469595E-18
      3.95514279731315E-09
      0.00000000000000E+00  -2.81687809015485E-12   0.00000000000000E+00   8.88155578100111E-13   3.27030285522981E-23
      2.81601155151155E-09   2.81689970708968E-09  -9.35230461760877E-19  -1.79793818975074E-01  -1.79793818974743E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.31003684614341E-10   0.00000000000000E+00  -3.31003684614341E-10
      4.09082018772994E-18  -2.30112952077761E-01  -2.29329771394058E-01   0.00000000000000E+00   1.52855029527725E-12
     -1.01654500585133E-22  -2.48742457277048E-09  -2.48589602247530E-09  -3.15558972596906E-18
      4.00514279731315E-09
      0.00000000000000E+00  -4.34251101990907E-12   0.00000000000000E+00   1.53827728434040E-12   7.37726019863286E-23
      4.34102582153364E-09   4.34256409881806E-09  -9.04972297575066E-19  -1.94087409269095E-01  -1.94087409267979E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11569746356257E-09   0.00000000000000E+00  -1.11569746356257E-09
      4.03503531455181E-18  -2.28393200720250E-01  -2.27376581531130E-01   0.00000000000000E+00   8.85943415908054E-12
     -9.99466963999339E-23  -3.23572606941448E-09  -3.22686663525549E-09  -3.13006301697675E-18
      4.05514279731315E-09
      0.00000000000000E+00  -6.23625765639107E-12   0.00000000000000E+00   1.90138120288867E-12   1.33754155659943E-22
      6.23434297596947E-09   6.23624435717250E-09  -8.71375636923443E-19  -2.09890283950419E-01  -2.09890283948807E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61229731563360E-09   0.00000000000000E+00  -1.61229731563360E-09
      3.95442044877013E-18  -2.17308036075472E-01  -2.15851260222353E-01   0.00000000000000E+00   1.33110612778640E-11
     -9.71521448351476E-23  -4.63725810281667E-09  -4.62394704153890E-09  -3.08304481184669E-18
      4.10514279731314E-09
      0.00000000000000E+00  -8.10584912698748E-12   0.00000000000000E+00   1.87072712740186E-12   1.97633713292599E-22
      8.10401071660854E-09   8.10588144373614E-09  -8.42251100552676E-19  -2.23733082831727E-01  -2.23733082829827E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89967720339094E-09   0.00000000000000E+00  -1.89967720339094E-09
      3.85943658860058E-18  -1.95916831459521E-01  -1.93961546798234E-01   0.00000000000000E+00   1.52985996645946E-11
     -9.35227003926035E-23  -6.22150284000972E-09  -6.20620424034522E-09  -3.01718548804791E-18
      4.15514279731314E-09
      0.00000000000000E+00  -9.76897362834138E-12   0.00000000000000E+00   1.66116094173627E-12   2.54946121764498E-22
      9.76734704096848E-09   9.76900820191047E-09  -8.17845112857544E-19  -2.35724866565674E-01  -2.35724866563453E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.22110475348223E-09   0.00000000000000E+00  -2.22110475348223E-09
      3.74838135092647E-18  -1.64429024073644E-01  -1.62051010329156E-01   0.00000000000000E+00   1.61708679459827E-11
     -8.91940146282436E-23  -7.56407431637409E-09  -7.54790344842820E-09  -2.93053623806893E-18
      4.20514279731314E-09
      0.00000000000000E+00  -1.10890580362252E-11   0.00000000000000E+00   1.32887693453649E-12   2.99698700641626E-22
      1.10877141323206E-08   1.10890430092554E-08  -7.96675347062401E-19  -2.46683084946614E-01  -2.46683084943991E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62301279332408E-09   0.00000000000000E+00  -2.62301279332408E-09
      3.61723071126027E-18  -1.24524848591316E-01  -1.21857552598932E-01   0.00000000000000E+00   1.55343793478212E-11
     -8.37911465345273E-23  -8.48156459527910E-09  -8.46603021593136E-09  -2.82055536419787E-18
      4.25514279731314E-09
      0.00000000000000E+00  -1.17932316363953E-11   0.00000000000000E+00   7.08930180773868E-13   3.22315081476662E-22
      1.17925274568154E-08   1.17932363869965E-08  -7.78316436216990E-19  -2.56796532641466E-01  -2.56796532638509E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95668176953541E-09   0.00000000000000E+00  -2.95668176953541E-09
      3.46939662278350E-18  -8.16665288703723E-02  -7.88824710230664E-02   0.00000000000000E+00   1.27821280101243E-11
     -5.65864462383996E-23  -8.84933674547114E-09  -8.83655461746107E-09  -2.69108018656651E-18
      4.30514279731314E-09
      0.00000000000000E+00  -1.16893552386136E-11   0.00000000000000E+00  -1.43373820647489E-14   3.31459479956740E-22
      1.16894780319655E-08   1.16894636945838E-08  -7.57435549462458E-19  -2.68091675381164E-01  -2.68091675377992E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.17206418876555E-09   0.00000000000000E+00  -3.17206418876555E-09
      3.31079341334522E-18  -4.56353587198120E-02  -4.29518615681050E-02   0.00000000000000E+00   8.97720360860895E-12
      7.10272839711202E-23  -8.52637670942690E-09  -8.51739950581822E-09  -2.55335786388276E-18
      4.35514279731314E-09
      0.00000000000000E+00  -1.08129727561793E-11   0.00000000000000E+00  -8.41165602728355E-13   3.55586168387323E-22
      1.08137686237794E-08   1.08129274581770E-08  -7.26301947422625E-19  -2.83322592880395E-01  -2.83322592877198E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19686470833264E-09   0.00000000000000E+00  -3.19686470833264E-09
      3.15095017792859E-18  -2.48880124826849E-02  -2.24884621884760E-02   0.00000000000000E+00   5.83281811587557E-12
      2.66683542135362E-22  -7.62189556796050E-09  -7.61606274984436E-09  -2.42464823050596E-18
      4.40514279731314E-09
      0.00000000000000E+00  -9.80111928636401E-12   0.00000000000000E+00  -9.75307122127864E-13   3.75198742089683E-22
      9.80207812266264E-09   9.80110281554088E-09  -6.91815281446002E-19  -2.99518040584567E-01  -2.99518040581640E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92727725894993E-09   0.00000000000000E+00  -2.92727725894993E-09
      3.00458631498109E-18  -1.57506050108228E-02  -1.35849019739952E-02   0.00000000000000E+00   3.44856132292591E-12
      4.17729501765665E-22  -6.87727411791433E-09  -6.87382555659098E-09  -2.31277103353509E-18
      4.45514279731314E-09
      0.00000000000000E+00  -8.77337667701178E-12   0.00000000000000E+00  -9.99030500493154E-13   3.57693318899175E-22
      8.77434628783484E-09   8.77334725733471E-09  -6.66290099019069E-19  -3.11738495214868E-01  -3.11738495212595E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27332722837628E-09   0.00000000000000E+00  -2.27332722837628E-09
      2.89091995356228E-18  -1.19307098858493E-02  -9.88277648274101E-03   0.00000000000000E+00   1.74673299179096E-12
      4.61329283777816E-22  -6.50176676195066E-09  -6.50002002895841E-09  -2.22462985454321E-18
      4.50514279731314E-09
      0.00000000000000E+00  -7.34317042921618E-12   0.00000000000000E+00  -1.41050868274869E-12   2.93022094193665E-22
      7.34458502484053E-09   7.34317451615807E-09  -6.61908943903364E-19  -3.14889945757157E-01  -3.14889945756150E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00769852211304E-09   0.00000000000000E+00  -1.00769852211304E-09
      2.84053502745663E-18  -1.05992036328969E-02  -8.60310985295283E-03   0.00000000000000E+00   1.66017125373754E-13
      3.93439904221292E-22  -6.33564201117083E-09  -6.33547599404506E-09  -2.17862608355326E-18
      4.55514279731314E-09
      0.00000000000000E+00  -5.19556493909258E-12   0.00000000000000E+00  -2.13611758972535E-12   1.85849750579426E-22
      5.19769007027087E-09   5.19555395268133E-09  -6.93132548283357E-19  -3.02598444674724E-01  -3.02598444675782E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05818414536173E-09   0.00000000000000E+00   1.05818414536173E-09
      2.89344423472471E-18  -1.14885991121204E-02  -9.51825852590996E-03   0.00000000000000E+00  -2.17379329524939E-12
      2.31126153397793E-22  -6.25156430474801E-09  -6.25373809804302E-09  -2.20031168644136E-18
      4.60514279731314E-09
      0.00000000000000E+00  -2.58019420237105E-12   0.00000000000000E+00  -2.62332417855909E-12   6.67992977118893E-23
      2.58280284876158E-09   2.58017952458309E-09  -7.66950554732718E-19  -2.70980454126368E-01  -2.70980454129771E-01
      0.00000000000000E+00   0.00000000000000E+00   3.40354133494406E-09   0.00000000000000E+00   3.40354133494406E-09
      3.06362130147191E-18  -1.71500479605102E-02  -1.52647837866603E-02   0.00000000000000E+00  -6.11019868468348E-12
      3.37330356243930E-23  -5.97761066084250E-09  -5.98372085952715E-09  -2.29667074673920E-18
      4.65514279731314E-09
      0.00000000000000E+00  -5.06064502013472E-14   0.00000000000000E+00  -2.58455998119979E-12  -1.23794668357911E-23
      5.31842833861206E-11   5.05997234049084E-11  -8.68096482866773E-19  -2.24650658194396E-01  -2.24650658199449E-01
      0.00000000000000E+00   0.00000000000000E+00   5.05312795810001E-09   0.00000000000000E+00   5.05312795810001E-09
      3.31627769937692E-18  -3.50321997916545E-02  -3.34241899069400E-02   0.00000000000000E+00  -1.31292485115097E-11
     -7.49899344618543E-23  -5.09059843299334E-09  -5.10372768150493E-09  -2.44818121651014E-18
      4.70514279731314E-09
      0.00000000000000E+00   1.57054500624871E-12   0.00000000000000E+00  -1.73008816433604E-12  -3.95131296199453E-23
     -1.56879025802068E-09  -1.57052034618505E-09  -9.76502142253784E-19  -1.71436831895958E-01  -1.71436831901569E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61032817623861E-09   0.00000000000000E+00   5.61032817623861E-09
      3.59679410818885E-18  -6.48397672450418E-02  -6.35669592726124E-02   0.00000000000000E+00  -2.46011344880956E-11
     -8.90262105169051E-23  -4.01520669556538E-09  -4.03980783005356E-09  -2.62029196593506E-18
      4.75514279731314E-09
      0.00000000000000E+00   1.93066822083942E-12   0.00000000000000E+00  -5.23092231865108E-13  -4.47363868401336E-23
     -1.93011280006685E-09  -1.93063589229876E-09  -1.07858176605881E-18  -1.18073835068113E-01  -1.18073835073375E-01
      0.00000000000000E+00   0.00000000000000E+00   5.26138814642466E-09   0.00000000000000E+00   5.26138814642466E-09
      3.85986351551008E-18  -9.85442582419930E-02  -9.74948466478489E-02   0.00000000000000E+00  -3.84434271117262E-11
     -9.79112069563727E-23  -3.29230882701408E-09  -3.33075225412590E-09  -2.78128174945127E-18
      4.80514279731314E-09
      0.00000000000000E+00   1.67662567772340E-12   0.00000000000000E+00   7.16266324825578E-14  -4.60953827042071E-23
     -1.67668346189266E-09  -1.67661183526023E-09  -1.16218581809340E-18  -7.17802363188349E-02  -7.17802363232501E-02
      0.00000000000000E+00   0.00000000000000E+00   4.41518270429353E-09   0.00000000000000E+00   4.41518270429353E-09
      4.08062265072476E-18  -1.32758145559248E-01  -1.31895308622119E-01   0.00000000000000E+00  -4.98527746205106E-11
     -1.07105820705729E-22  -2.68871809441269E-09  -2.73857086903330E-09  -2.91843683263136E-18
      4.85514279731314E-09
      0.00000000000000E+00   1.12298560183643E-12   0.00000000000000E+00   4.06137944706248E-13  -4.68758882793615E-23
     -1.12338537744741E-09  -1.12297923950275E-09  -1.21681400289851E-18  -4.01682394296976E-02  -4.01682394329111E-02
      0.00000000000000E+00   0.00000000000000E+00   3.21346007240707E-09   0.00000000000000E+00   3.21346007240707E-09
      4.24129565434511E-18  -1.65908587123338E-01  -1.65249941368606E-01   0.00000000000000E+00  -5.22635548145547E-11
     -1.14961399661214E-22  -2.03821727808966E-09  -2.09048083290433E-09  -3.02448165144660E-18
      4.90514279731314E-09
      0.00000000000000E+00   5.85418354960776E-13   0.00000000000000E+00   4.55977808582011E-13  -4.72694298765226E-23
     -5.85821029014398E-10  -5.85365051205863E-10  -1.24429263845350E-18  -2.39059201367197E-02  -2.39059201387479E-02
      0.00000000000000E+00   0.00000000000000E+00   2.02817878068669E-09   0.00000000000000E+00   2.02817878068669E-09
      4.34270459337945E-18  -1.94860234517491E-01  -1.94405648018993E-01   0.00000000000000E+00  -4.40223176884132E-11
     -1.20811952950652E-22  -1.39879141179226E-09  -1.44281372948080E-09  -3.09841195492594E-18
      4.93014279731314E-09
      0.00000000000000E+00   3.67287104092900E-13   0.00000000000000E+00   3.87276948334642E-13  -4.73801458029293E-23
     -3.67704256982235E-10  -3.67316980033948E-10  -1.25256155798900E-18  -1.90079772755915E-02  -1.90079772770761E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48460271990617E-09   0.00000000000000E+00   1.48460271990617E-09
      4.37981966137710E-18  -2.07366340927541E-01  -2.07014317764532E-01   0.00000000000000E+00  -3.73973982641045E-11
     -1.23141824234248E-22  -1.07988834160805E-09  -1.11728573987228E-09  -3.12725810338810E-18
      4.96389279731314E-09
      0.00000000000000E+00   2.38980006213985E-13   0.00000000000000E+00   1.64761889977637E-13  -4.74658507069702E-23
     -2.39143154609145E-10  -2.38978392719215E-10  -1.25938702454733E-18  -1.50488324774254E-02  -1.50488324784993E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07386751263856E-09   0.00000000000000E+00   1.07386751263856E-09
      4.41606268992865E-18  -2.20516408290054E-01  -2.20253360906394E-01   0.00000000000000E+00  -2.83863362205130E-11
     -1.25444230583699E-22  -8.06502783698705E-10  -8.34889119919344E-10  -3.15667566538132E-18
      5.00945529731314E-09
      0.00000000000000E+00   1.66147129608416E-13   0.00000000000000E+00   6.69716726593327E-14  -4.75301256908725E-23
     -1.66245637190077E-10  -1.66178665517466E-10  -1.26529396802493E-18  -1.17832426197250E-02  -1.17832426204955E-02
      0.00000000000000E+00   0.00000000000000E+00   7.70506660371714E-10   0.00000000000000E+00   7.70506660371714E-10
      4.45116889964184E-18  -2.33199417581661E-01  -2.33009014183202E-01   0.00000000000000E+00  -2.00220418494519E-11
     -1.27564091309770E-22  -5.84305953004647E-10  -6.04327994854226E-10  -3.18587493161691E-18
      5.03445529731314E-09
      0.00000000000000E+00   1.35838366329932E-13   0.00000000000000E+00   5.24832710694168E-14  -4.75525743284633E-23
     -1.35929248809743E-10  -1.35876765538721E-10  -1.26778250122177E-18  -1.04693203139639E-02  -1.04693203145987E-02
      0.00000000000000E+00   0.00000000000000E+00   6.34819804821740E-10   0.00000000000000E+00   6.34819804821740E-10
      4.46703939476238E-18  -2.38824706043563E-01  -2.38667506720967E-01   0.00000000000000E+00  -1.59704702479006E-11
     -1.28472141025886E-22  -4.82972569034996E-10  -4.98943039283025E-10  -3.19925689354061E-18
      5.06820529731314E-09
      0.00000000000000E+00   1.14622232034993E-13   0.00000000000000E+00   2.68451769239469E-14  -4.75717839250107E-23
     -1.14659095676042E-10  -1.14632250499165E-10  -1.27043646775397E-18  -9.13395324839929E-03  -9.13395324894306E-03
      0.00000000000000E+00   0.00000000000000E+00   5.43770350400408E-10   0.00000000000000E+00   5.43770350400408E-10
      4.48539164408839E-18  -2.45239606374811E-01  -2.45104400940529E-01   0.00000000000000E+00  -1.31524272116662E-11
     -1.29463896970271E-22  -4.15985672689429E-10  -4.29138099901225E-10  -3.21495517633443E-18
      5.11376779731314E-09
      0.00000000000000E+00   9.50593030097902E-14   0.00000000000000E+00   1.96466989966719E-14  -4.75833173907357E-23
     -9.50940609786204E-11  -9.50744142796713E-11  -1.27315325296645E-18  -7.85786460742104E-03  -7.85786460788885E-03
      0.00000000000000E+00   0.00000000000000E+00   4.67813502335081E-10   0.00000000000000E+00   4.67813502335081E-10
      4.50670639678853E-18  -2.52648246580641E-01  -2.52530811182910E-01   0.00000000000000E+00  -1.08114312587447E-11
     -1.30543816319749E-22  -3.61927656796580E-10  -3.72739088055455E-10  -3.23355314382209E-18
      5.16376779731314E-09
      0.00000000000000E+00   7.77006476775676E-14   0.00000000000000E+00   1.79791781854253E-14  -4.75821061353517E-23
     -7.76898292683853E-11  -7.76718500902474E-11  -1.27530023881476E-18  -6.94580869397587E-03  -6.94580869439388E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18009002065167E-10   0.00000000000000E+00   4.18009002065167E-10
      4.52760684689180E-18  -2.60156516805257E-01  -2.60049290520101E-01   0.00000000000000E+00  -9.55273257300738E-12
     -1.31570922958885E-22  -3.30784419401760E-10  -3.40337151974899E-10  -3.25230660807703E-18
      5.21376779731314E-09
      0.00000000000000E+00   5.96990791848924E-14   0.00000000000000E+00   2.09557867289951E-14  -4.75667309192150E-23
     -5.97297160289805E-11  -5.97087602422991E-11  -1.27659539687147E-18  -6.47307623703392E-03  -6.47307623746332E-03
      0.00000000000000E+00   0.00000000000000E+00   4.29400972842867E-10   0.00000000000000E+00   4.29400972842867E-10
      4.54907689553394E-18  -2.69220605664385E-01  -2.69104130253013E-01   0.00000000000000E+00  -1.15445436873216E-11
     -1.32787514922542E-22  -3.58147668913114E-10  -3.69692212600568E-10  -3.27248149866247E-18
      5.26376779731314E-09
      0.00000000000000E+00   3.47173106644451E-14   0.00000000000000E+00   3.13414490383494E-14  -4.75314410018108E-23
     -3.47863144361212E-11  -3.47549729871304E-11  -1.27670741638949E-18  -6.59215338767257E-03  -6.59215338814649E-03
      0.00000000000000E+00   0.00000000000000E+00   4.73915392829861E-10   0.00000000000000E+00   4.73915392829861E-10
      4.57277266517543E-18  -2.81444688166850E-01  -2.81306324897343E-01   0.00000000000000E+00  -1.59142138088703E-11
     -1.34431369224188E-22  -4.23246206033707E-10  -4.39160419842712E-10  -3.29606524878594E-18
      5.31376779731314E-09
      0.00000000000000E+00  -2.25019606158441E-14   0.00000000000000E+00   7.15967741716242E-14  -4.74483551782902E-23
      2.23921942822742E-11   2.24637910563983E-11  -1.27405949834221E-18  -8.27472146841020E-03  -8.27472146883200E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21807425660719E-10   0.00000000000000E+00   4.21807425660719E-10
      4.59386303645847E-18  -2.95382299964877E-01  -2.95242326530404E-01   0.00000000000000E+00  -1.67764569041000E-11
     -1.36131853987956E-22  -4.27494759812866E-10  -4.44271216717102E-10  -3.31980353811626E-18
      5.36376779731314E-09
      0.00000000000000E+00  -2.37234956207042E-13   0.00000000000000E+00   2.58503604499419E-13  -4.71828815725762E-23
      2.36950347673874E-10   2.37208851278326E-10  -1.26093934220422E-18  -1.60509828835155E-02  -1.60509828835891E-02
      0.00000000000000E+00   0.00000000000000E+00   7.35489927639118E-11   0.00000000000000E+00   7.35489927639118E-11
      4.59754048609666E-18  -3.10129269250463E-01  -3.10031363488449E-01   0.00000000000000E+00  -8.88449376795097E-12
     -1.37031949943364E-22  -3.01873350274171E-10  -3.10757844042259E-10  -3.33660114389244E-18
      5.41376779731314E-09
      0.00000000000000E+00  -7.78659682045412E-13   0.00000000000000E+00   6.50334315733923E-13  -4.64913017928155E-23
      7.78027150792794E-10   7.78677485108481E-10  -1.22180341951184E-18  -3.85756443919188E-02  -3.85756443911220E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.96764369766968E-10   0.00000000000000E+00  -7.96764369766968E-10
      4.55770226760831E-18  -3.26183572526001E-01  -3.26189280554146E-01   0.00000000000000E+00   1.21841455988037E-11
     -1.35853145610141E-22   5.90273905980273E-12   1.80868846584705E-11  -3.33589884809647E-18
      5.46376779731314E-09
      0.00000000000000E+00  -1.22759675751580E-12   0.00000000000000E+00   5.88076829214971E-13  -4.54398361523961E-23
      1.22699030802165E-09   1.22757838485082E-09  -1.16373957862141E-18  -7.07120657490708E-02  -7.07120657476331E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.43773991842952E-09   0.00000000000000E+00  -1.43773991842952E-09
      4.48581527168684E-18  -3.42112062581262E-01  -3.42178293055041E-01   0.00000000000000E+00   2.60138367944605E-11
     -1.33195923581948E-22   1.84147696784366E-10   2.10161533578693E-10  -3.32207569306542E-18
      5.51376779731314E-09
      0.00000000000000E+00  -1.59626153266681E-12   0.00000000000000E+00   4.97883663340240E-13  -4.29377070493971E-23
      1.59574704068512E-09   1.59624492434841E-09  -1.09781001353747E-18  -1.05530088218021E-01  -1.05530088216291E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73011806992453E-09   0.00000000000000E+00  -1.73011806992453E-09
      4.39930936819061E-18  -3.56237922075359E-01  -3.56280125780898E-01   0.00000000000000E+00   3.02698558384774E-11
     -1.29893873163867E-22   1.03603289737801E-10   1.33873145576148E-10  -3.30149935465314E-18
      5.56376779731314E-09
      0.00000000000000E+00  -2.28592366435813E-12   0.00000000000000E+00   7.95676508696892E-13  -3.28996542234053E-23
      2.28513635995734E-09   2.28593203646601E-09  -1.02766874687548E-18  -1.40794680356589E-01  -1.40794680354630E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.95892821546024E-09   0.00000000000000E+00  -1.95892821546024E-09
      4.30136295741760E-18  -3.66534752551071E-01  -3.66431772246109E-01   0.00000000000000E+00   3.30185745118839E-11
     -1.26010141007598E-22  -3.60022395517512E-10  -3.27003821005754E-10  -3.27369421054212E-18
      5.61376779731314E-09
      0.00000000000000E+00  -3.90404424448034E-12   0.00000000000000E+00   1.68996627957054E-12   1.95599484364945E-24
      3.90234347497786E-09   3.90403344125744E-09  -9.55420557537790E-19  -1.75397630955130E-01  -1.75397630952847E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28309223619625E-09   0.00000000000000E+00  -2.28309223619625E-09
      4.18720834560779E-18  -3.68169524883840E-01  -3.67658918294175E-01   0.00000000000000E+00   3.84151298675973E-11
     -1.21102874078973E-22  -1.65935633492869E-09  -1.62094120506121E-09  -3.23178778807000E-18
      5.66376779731314E-09
      0.00000000000000E+00  -6.75435381897872E-12   0.00000000000000E+00   2.87860012805059E-12   7.06908646479891E-23
      6.75146973054157E-09   6.75434833066969E-09  -8.90475087679480E-19  -2.05310259754818E-01  -2.05310259752224E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.59393646079423E-09   0.00000000000000E+00  -2.59393646079423E-09
      4.05751152256807E-18  -3.53030163995096E-01  -3.51719525353385E-01   0.00000000000000E+00   4.45096568785538E-11
     -1.14926685007378E-22  -4.20492152675390E-09  -4.16041186987547E-09  -3.16703643488860E-18
      5.71376779731314E-09
      0.00000000000000E+00  -9.91803763682919E-12   0.00000000000000E+00   3.16229908815073E-12   1.48782084499619E-22
      9.91488497292784E-09   9.91804727201614E-09  -8.42067289499562E-19  -2.27336414116111E-01  -2.27336414113298E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81334079262087E-09   0.00000000000000E+00  -2.81334079262087E-09
      3.91684448293703E-18  -3.16557122859677E-01  -3.14318874900531E-01   0.00000000000000E+00   4.70697536252703E-11
     -1.07967153321021E-22  -7.15177623302040E-09  -7.10470647939524E-09  -3.07477719343747E-18
      5.76376779731314E-09
      0.00000000000000E+00  -1.20711538111852E-11   0.00000000000000E+00   2.14901868331082E-12   2.03965032282834E-22
      1.20690558965310E-08   1.20712049152145E-08  -8.10111063121977E-19  -2.42314314928232E-01  -2.42314314925286E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.94654449097776E-09   0.00000000000000E+00  -2.94654449097776E-09
      3.76951725838815E-18  -2.63982102291534E-01  -2.61107417033141E-01   0.00000000000000E+00   4.25221438532964E-11
     -1.00747019727283E-22  -9.16718256809000E-09  -9.12466042423680E-09  -2.95940619526617E-18
      5.81376779731313E-09
      0.00000000000000E+00  -1.30945797178887E-11   0.00000000000000E+00   1.02535726386546E-12   2.29622204696143E-22
      1.30935804828679E-08   1.30946058401320E-08  -7.88297044182665E-19  -2.53190847688385E-01  -2.53190847685396E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98926867251466E-09   0.00000000000000E+00  -2.98926867251466E-09
      3.62005382476241E-18  -2.06117712350606E-01  -2.02934003262670E-01   0.00000000000000E+00   3.28548968608627E-11
     -9.35431280261325E-23  -1.01381920644781E-08  -1.01053371676173E-08  -2.83175678057975E-18
      5.86376779731313E-09
      0.00000000000000E+00  -1.33339271030515E-11   0.00000000000000E+00   2.46730311641731E-13   2.33873393492841E-22
      1.33336708453840E-08   1.33339175756958E-08  -7.72317811578180E-19  -2.61825006664872E-01  -2.61825006661887E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98507551995774E-09   0.00000000000000E+00  -2.98507551995774E-09
      3.47080004876452E-18  -1.48307573540543E-01  -1.45047099203549E-01   0.00000000000000E+00   2.44286231973679E-11
     -8.72551265425619E-23  -1.03732706789354E-08  -1.03488420557381E-08  -2.69848223718634E-18
      5.91376779731313E-09
      0.00000000000000E+00  -1.31341647996252E-11   0.00000000000000E+00  -1.67335278613960E-13   2.27032518561833E-22
      1.31343485290008E-08   1.31341811937224E-08  -7.59150235828076E-19  -2.69446057939181E-01  -2.69446057936231E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.95034783065610E-09   0.00000000000000E+00  -2.95034783065610E-09
      3.32328265723172E-18  -9.43849327833522E-02  -9.11764180313618E-02   0.00000000000000E+00   1.77491977408985E-11
     -7.57133942572417E-23  -1.02015825608072E-08  -1.01838333630664E-08  -2.56413242140364E-18
      5.96376779731313E-09
      0.00000000000000E+00  -1.24337568336806E-11   0.00000000000000E+00  -6.81210690764998E-13   2.19929234962133E-22
      1.24344324675895E-08   1.24337512568989E-08  -7.43917310802302E-19  -2.77886011908865E-01  -2.77886011906011E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85443750487481E-09   0.00000000000000E+00  -2.85443750487481E-09
      3.18056078198798E-18  -5.15253649946006E-02  -4.85072807955174E-02   0.00000000000000E+00   1.19270190256272E-11
     -4.89132777941640E-24  -9.59124077104976E-09  -9.57931375202413E-09  -2.43664347118568E-18
      6.01376779731313E-09
      0.00000000000000E+00  -1.10981506652087E-11   0.00000000000000E+00  -1.30154613956933E-12   2.31299826155127E-22
      1.10994232185028E-08   1.10981216723634E-08  -7.19157516218418E-19  -2.89825493776999E-01  -2.89825493774348E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65106289549994E-09   0.00000000000000E+00  -2.65106289549994E-09
      3.04800763721298E-18  -2.76089917874030E-02  -2.49476263721195E-02   0.00000000000000E+00   7.25862780635962E-12
      1.35074752739361E-22  -8.45431740466997E-09  -8.44705877686348E-09  -2.32885012099456E-18
      6.06376779731313E-09
      0.00000000000000E+00  -9.97250156599325E-12   0.00000000000000E+00  -1.09055584932427E-12   2.53674136881278E-22
      9.97354744893200E-09   9.97245689308293E-09  -6.88047946168092E-19  -3.04029016445858E-01  -3.04029016443396E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46255291208950E-09   0.00000000000000E+00  -2.46255291208950E-09
      2.92487999160851E-18  -1.71869300040686E-02  -1.48208222980477E-02   0.00000000000000E+00   4.31254597219618E-12
      2.57209991070409E-22  -7.51421652696589E-09  -7.50990398099344E-09  -2.23683204544041E-18
      6.11376779731313E-09
      0.00000000000000E+00  -9.32159791340351E-12   0.00000000000000E+00  -6.24547941779870E-13   2.68983563442435E-22
      9.32221774655218E-09   9.32159319861066E-09  -6.56374581616906E-19  -3.18417237238993E-01  -3.18417237236634E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35872813040556E-09   0.00000000000000E+00  -2.35872813040556E-09
      2.80694358508823E-18  -1.24162485119728E-02  -1.02224894021586E-02   0.00000000000000E+00   2.79277969430066E-12
      3.36253464588036E-22  -6.96565784789974E-09  -6.96286506820511E-09  -2.15056900347132E-18
      6.16376779731313E-09
      0.00000000000000E+00  -9.04092039649731E-12   0.00000000000000E+00  -2.58331037932183E-13   2.72545195915633E-22
      9.04120145006853E-09   9.04094311903086E-09  -6.24634896457596E-19  -3.32941109097675E-01  -3.32941109095287E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38760736027927E-09   0.00000000000000E+00  -2.38760736027927E-09
      2.68756321707426E-18  -9.80985931407057E-03  -7.71362028635030E-03   0.00000000000000E+00   2.13111191211393E-12
      3.77892836740050E-22  -6.65546687066408E-09  -6.65333575875159E-09  -2.06292832061667E-18
      6.21376779731313E-09
      0.00000000000000E+00  -9.07572955189896E-12   0.00000000000000E+00   5.09896192126339E-14   2.66206930916463E-22
      9.07570813612537E-09   9.07575912574485E-09  -5.90666130343093E-19  -3.48508628718141E-01  -3.48508628715562E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57883506367754E-09   0.00000000000000E+00  -2.57883506367754E-09
      2.55862146389039E-18  -8.15423403857559E-03  -6.10727228563476E-03   0.00000000000000E+00   1.88706703920051E-12
      3.92377658133155E-22  -6.49881112910691E-09  -6.49692406206732E-09  -1.96795533354729E-18
      6.26376779731313E-09
      0.00000000000000E+00  -9.01832659114426E-12   0.00000000000000E+00  -4.10240957048538E-14   2.43963718784189E-22
      9.01839379442178E-09   9.01835277032632E-09  -5.57497997531236E-19  -3.63769174314112E-01  -3.63769174311509E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60255588239878E-09   0.00000000000000E+00  -2.60255588239878E-09
      2.42849366977045E-18  -7.00431156431531E-03  -4.98290825848882E-03   0.00000000000000E+00   1.63114253546748E-12
      3.73501249068114E-22  -6.41742803046341E-09  -6.41579688792757E-09  -1.87099567223921E-18
      6.31376779731313E-09
      0.00000000000000E+00  -8.76860075067699E-12   0.00000000000000E+00  -2.32616918341476E-13   2.07369436688283E-22
      8.76885898498748E-09   8.76862636806935E-09  -5.28137350194071E-19  -3.77352397682936E-01  -3.77352397680541E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39589451520770E-09   0.00000000000000E+00  -2.39589451520770E-09
      2.30869894401006E-18  -6.19723081460890E-03  -4.18939425477125E-03   0.00000000000000E+00   1.32098409810468E-12
      3.24675655538973E-22  -6.37405283696006E-09  -6.37273185286163E-09  -1.78056159381599E-18
      6.36376779731313E-09
      0.00000000000000E+00  -8.25702556443107E-12   0.00000000000000E+00  -4.95098173949412E-13   1.62941585639856E-22
      8.25753579313874E-09   8.25704069496495E-09  -5.06499456846812E-19  -3.87533435204820E-01  -3.87533435202939E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88151055080116E-09   0.00000000000000E+00  -1.88151055080116E-09
      2.21462341647001E-18  -5.65743653321077E-03  -3.64871667993988E-03   0.00000000000000E+00   8.91667589686563E-13
      2.57834866336941E-22  -6.37642181175372E-09  -6.37553014416378E-09  -1.70812395962319E-18
      6.41376779731313E-09
      0.00000000000000E+00  -7.11300751777412E-12   0.00000000000000E+00  -1.12608896608023E-12   1.15592275074559E-22
      7.11411012228713E-09   7.11298403332117E-09  -5.03381638039336E-19  -3.89854677344621E-01  -3.89854677343959E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62632703266570E-10   0.00000000000000E+00  -6.62632703266570E-10
      2.18149178130668E-18  -5.37545764745725E-03  -3.34316298253576E-03   0.00000000000000E+00   6.19648233559481E-14
      1.82464859571458E-22  -6.45041329487815E-09  -6.45035133005461E-09  -1.67811014326734E-18
      6.46376779731313E-09
      0.00000000000000E+00  -4.80540849543501E-12   0.00000000000000E+00  -2.28868783797493E-12   6.57815587358085E-23
      4.80766299314142E-09   4.80537430530351E-09  -5.38992873728260E-19  -3.76183086111651E-01  -3.76183086113340E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68922303338827E-09   0.00000000000000E+00   1.68922303338827E-09
      2.26595293297609E-18  -5.41594094082072E-03  -3.36970556134099E-03   0.00000000000000E+00  -1.50717183385029E-12
      9.97733734229806E-23  -6.49309016685803E-09  -6.49459733869178E-09  -1.72696005924783E-18
      6.51376779731313E-09
      0.00000000000000E+00  -2.03527937651879E-12   0.00000000000000E+00  -2.77246472877378E-12   1.24111489738042E-23
      2.03802917825007E-09   2.03525671352131E-09  -6.26560056051174E-19  -3.41044649408570E-01  -3.41044649412956E-01
      0.00000000000000E+00   0.00000000000000E+00   4.38649838285298E-09   0.00000000000000E+00   4.38649838285298E-09
      2.48527785211874E-18  -6.55637406014022E-03  -4.53309019143183E-03   0.00000000000000E+00  -4.24854892999502E-12
      4.97548992457118E-24  -6.41750654744427E-09  -6.42175509637426E-09  -1.85871779606757E-18
      6.56376779731313E-09
      0.00000000000000E+00  -7.45779266125117E-14   0.00000000000000E+00  -1.99186682327434E-12  -2.82520599713612E-23
      7.65528392529055E-11   7.45609724296029E-11  -7.52486132618210E-19  -2.87985966958613E-01  -2.87985966964603E-01
      0.00000000000000E+00   0.00000000000000E+00   5.99074454513313E-09   0.00000000000000E+00   5.99074454513313E-09
      2.78481507937540E-18  -1.25850930826162E-02  -1.06741247630517E-02   0.00000000000000E+00  -8.82301410352220E-12
     -6.57818925027378E-23  -6.05648250345915E-09  -6.06530551756274E-09  -2.03232894675719E-18
      6.61376779731313E-09
      0.00000000000000E+00   1.37188483966883E-12   0.00000000000000E+00  -1.54560641809863E-12  -4.09165025540286E-23
     -1.37028658144242E-09  -1.37183218786056E-09  -8.82584290115305E-19  -2.28307909913557E-01  -2.28307909919952E-01
      0.00000000000000E+00   0.00000000000000E+00   6.39538910317736E-09   0.00000000000000E+00   6.39538910317736E-09
      3.10458453453426E-18  -3.29568459172865E-02  -3.13740919189160E-02   0.00000000000000E+00  -1.66956051386424E-11
     -8.22125602545938E-23  -5.00686131017810E-09  -5.02355691531683E-09  -2.22200024441896E-18
      6.66376779731313E-09
      0.00000000000000E+00   2.10223418994308E-12   0.00000000000000E+00  -8.75515760960323E-13  -4.36492871890834E-23
     -2.10134374008026E-09  -2.10221925584126E-09  -1.00146772758563E-18  -1.69081193120215E-01  -1.69081193126306E-01
      0.00000000000000E+00   0.00000000000000E+00   6.09113383128393E-09   0.00000000000000E+00   6.09113383128393E-09
      3.40914122609846E-18  -6.46085179179604E-02  -6.33517426829683E-02   0.00000000000000E+00  -2.90422671341711E-11
     -9.08656775220990E-23  -3.95987230830841E-09  -3.98891457544267E-09  -2.40767349851283E-18
      6.71376779731313E-09
      0.00000000000000E+00   2.09580505833855E-12   0.00000000000000E+00  -1.82993812717277E-13  -4.52002303853540E-23
     -2.09561218769824E-09  -2.09579518151100E-09  -1.10665326055576E-18  -1.12944754596967E-01  -1.12944754602392E-01
      0.00000000000000E+00   0.00000000000000E+00   5.42496135122803E-09   0.00000000000000E+00   5.42496135122803E-09
      3.68038929365986E-18  -9.95438624100555E-02  -9.84949495565457E-02   0.00000000000000E+00  -4.39381545223616E-11
     -1.00612761799273E-22  -3.28522801519456E-09  -3.32916616971702E-09  -2.57373603310411E-18
      6.73876779731313E-09
      0.00000000000000E+00   1.91643228657225E-12   0.00000000000000E+00   1.42704407818992E-13  -4.59635132846349E-23
     -1.91661442149280E-09  -1.91647171708503E-09  -1.15374977738680E-18  -8.65797319673682E-02  -8.65797319722814E-02
      0.00000000000000E+00   0.00000000000000E+00   4.91325006445038E-09   0.00000000000000E+00   4.91325006445038E-09
      3.80322054527112E-18  -1.17486392002736E-01  -1.16542198687461E-01   0.00000000000000E+00  -5.57160203695875E-11
     -1.05548785553534E-22  -2.94106232699563E-09  -2.99677834736532E-09  -2.64947076788433E-18
      6.77251779731313E-09
      0.00000000000000E+00   1.58928133263904E-12   0.00000000000000E+00   2.81137262185983E-13  -4.68292510507067E-23
     -1.58951669001554E-09  -1.58923555275340E-09  -1.20556702868827E-18  -5.66269940491613E-02  -5.66269940533648E-02
      0.00000000000000E+00   0.00000000000000E+00   4.20349512423408E-09   0.00000000000000E+00   4.20349512423408E-09
      3.94508850571402E-18  -1.41846124897645E-01  -1.41022451486821E-01   0.00000000000000E+00  -6.08523335297463E-11
     -1.11937241052696E-22  -2.55340723795078E-09  -2.61425957148063E-09  -2.73952147702575E-18
      6.81808029731313E-09
      0.00000000000000E+00   9.92657919738949E-13   0.00000000000000E+00   5.12562350004817E-13  -4.75124291487387E-23
     -9.93183739597284E-10  -9.92671177247327E-10  -1.24806655744505E-18  -3.12662408321537E-02  -3.12662408351683E-02
      0.00000000000000E+00   0.00000000000000E+00   3.01453710262238E-09   0.00000000000000E+00   3.01453710262238E-09
      4.08243835245225E-18  -1.74549475686060E-01  -1.73912447632989E-01   0.00000000000000E+00  -5.88708606592375E-11
     -1.19106220238914E-22  -1.96299506471571E-09  -2.02186592537506E-09  -2.83437179500721E-18
      6.86808029731313E-09
      0.00000000000000E+00   4.78327391376799E-13   0.00000000000000E+00   4.48828808090416E-13  -4.78074385770013E-23
     -4.78743886726354E-10  -4.78295057918311E-10  -1.26899551646573E-18  -1.85123871805700E-02  -1.85123871824662E-02
      0.00000000000000E+00   0.00000000000000E+00   1.89618253169637E-09   0.00000000000000E+00   1.89618253169637E-09
      4.17724747903707E-18  -2.06523738973254E-01  -2.06077006137175E-01   0.00000000000000E+00  -4.91348592150655E-11
     -1.25290900933456E-22  -1.36875261456288E-09  -1.41788747377807E-09  -2.90825196257134E-18
      6.91808029731313E-09
      0.00000000000000E+00   2.46786808876624E-13   0.00000000000000E+00   2.06975733916804E-13  -4.79124805979141E-23
     -2.47023790666534E-10  -2.46816814932665E-10  -1.27840696039068E-18  -1.28307815119383E-02  -1.28307815131571E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21879562004418E-09   0.00000000000000E+00   1.21879562004418E-09
      4.23818726003928E-18  -2.30739286991949E-01  -2.30433047138873E-01   0.00000000000000E+00  -3.65593013840349E-11
     -1.29437011087664E-22  -9.35419503727332E-10  -9.71978805111496E-10  -2.95978029964861E-18
      6.96808029731313E-09
      0.00000000000000E+00   1.61003824324794E-13   0.00000000000000E+00   7.70800930348179E-14  -4.79516617495349E-23
     -1.61123130842002E-10  -1.61046050749015E-10  -1.28358418959767E-18  -9.88614806274958E-03  -9.88614806357535E-03
      0.00000000000000E+00   0.00000000000000E+00   8.25767481548386E-10   0.00000000000000E+00   8.25767481548386E-10
      4.27947563411670E-18  -2.47068493115758E-01  -2.46859062216120E-01   0.00000000000000E+00  -2.45156892080518E-11
     -1.32179352987182E-22  -6.40205741591224E-10  -6.64721430799408E-10  -2.99589144451903E-18
      7.01808029731313E-09
      0.00000000000000E+00   1.25000687339444E-13   0.00000000000000E+00   3.34481087665151E-14  -4.79640110689815E-23
     -1.25045409378021E-10  -1.25011961269302E-10  -1.28700839419319E-18  -8.10737322077615E-03  -8.10737322138672E-03
      0.00000000000000E+00   0.00000000000000E+00   6.10570788206947E-10   0.00000000000000E+00   6.10570788206947E-10
      4.31000417352705E-18  -2.58256674428693E-01  -2.58103693475313E-01   0.00000000000000E+00  -1.63573029945420E-11
     -1.34040339071436E-22  -4.69201523942960E-10  -4.85558826937636E-10  -3.02299577933386E-18
      7.06808029731313E-09
      0.00000000000000E+00   1.05896982000278E-13   0.00000000000000E+00   1.93995105829164E-14  -4.79626924969592E-23
     -1.05880913951216E-10  -1.05861514440681E-10  -1.28952135193806E-18  -6.91168642384582E-03  -6.91168642435255E-03
      0.00000000000000E+00   0.00000000000000E+00   5.06727301168581E-10   0.00000000000000E+00   5.06727301168581E-10
      4.33534053858548E-18  -2.67047255260725E-01  -2.66920959196832E-01   0.00000000000000E+00  -1.23668374849008E-11
     -1.35230349321445E-22  -3.88498949242831E-10  -4.00865786727867E-10  -3.04581918664742E-18
      7.11808029731313E-09
      0.00000000000000E+00   9.36816319516773E-14   0.00000000000000E+00   1.39910115484954E-14  -4.79532519005409E-23
     -9.37015828786627E-11  -9.36875918671622E-11  -1.29147086755994E-18  -6.06073250933877E-03  -6.06073250978756E-03
      0.00000000000000E+00   0.00000000000000E+00   4.48789400928901E-10   0.00000000000000E+00   4.48789400928901E-10
      4.35778000863192E-18  -2.74575264271172E-01  -2.74463387455352E-01   0.00000000000000E+00  -1.01909661339881E-11
     -1.36312476242380E-22  -3.44910842927643E-10  -3.55101809061768E-10  -3.06630914107198E-18
      7.14308029731313E-09
      0.00000000000000E+00   8.78035687703956E-14   0.00000000000000E+00   1.43361453967945E-14  -4.79465167745898E-23
     -8.78022656894859E-11  -8.77879295441371E-11  -1.29230934379410E-18  -5.71891857035002E-03  -5.71891857077085E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20826688740058E-10   0.00000000000000E+00   4.20826688740058E-10
      4.36830067585043E-18  -2.78031941591955E-01  -2.77927016354903E-01   0.00000000000000E+00  -9.11354909677838E-12
     -1.36736808941343E-22  -3.23925210099040E-10  -3.33038759195955E-10  -3.07599133205633E-18
      7.17683029731313E-09
      0.00000000000000E+00   8.09152134798311E-14   0.00000000000000E+00   1.35457404215178E-14  -4.79343037779723E-23
     -8.09254542894801E-11  -8.09119085491065E-11  -1.29323062765875E-18  -5.36236669661624E-03  -5.36236669703951E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23266890722643E-10   0.00000000000000E+00   4.23266890722643E-10
      4.38258593341231E-18  -2.83069572671932E-01  -2.82961712067343E-01   0.00000000000000E+00  -9.94898591580513E-12
     -1.36989267026867E-22  -3.32405996257631E-10  -3.42354982173573E-10  -3.08935530575357E-18
      7.22239279731313E-09
      0.00000000000000E+00   7.09959818614182E-14   0.00000000000000E+00   1.54186350380072E-14  -4.79118077068075E-23
     -7.10179715169080E-11  -7.10025528819179E-11  -1.29406750596250E-18  -5.04267567760132E-03  -5.04267567807675E-03
      0.00000000000000E+00   0.00000000000000E+00   4.75426734906625E-10   0.00000000000000E+00   4.75426734906625E-10
      4.40424756402150E-18  -2.92184142611937E-01  -2.92056725283145E-01   0.00000000000000E+00  -1.41965625225203E-11
     -1.38663555044833E-22  -3.90227619502037E-10  -4.04424182024696E-10  -3.11018005805900E-18
      7.27239279731313E-09
      0.00000000000000E+00   5.96990791848924E-14   0.00000000000000E+00   1.72318546314809E-14  -4.78792944989718E-23
     -5.97025674239413E-11  -5.96853355693577E-11  -1.29448282071118E-18  -4.87907049717345E-03  -4.87907049772260E-03
      0.00000000000000E+00   0.00000000000000E+00   5.49142479938749E-10   0.00000000000000E+00   5.49142479938749E-10
      4.43170468801843E-18  -3.05611557156910E-01  -3.05457347730870E-01   0.00000000000000E+00  -2.03091298080506E-11
     -1.40479305394673E-22  -4.69148014561207E-10  -4.89457144369398E-10  -3.13722186730726E-18
      7.32239279731313E-09
      0.00000000000000E+00   4.33507159619526E-14   0.00000000000000E+00   2.43838957180429E-14  -4.78344732453791E-23
     -4.33834892322714E-11  -4.33591053366012E-11  -1.29415119958761E-18  -5.11410376003894E-03  -5.11410376058924E-03
      0.00000000000000E+00   0.00000000000000E+00   5.50299166165271E-10   0.00000000000000E+00   5.50299166165271E-10
      4.45921964632669E-18  -3.20143301434374E-01  -3.19983583614406E-01   0.00000000000000E+00  -2.23534700148655E-11
     -1.42663891863962E-22  -4.84586590813685E-10  -5.06940060828693E-10  -3.16506844673909E-18
      7.37239279731313E-09
      0.00000000000000E+00  -1.91037053391656E-14   0.00000000000000E+00   7.96038264932454E-14  -4.77350558909342E-23
      1.89840959994583E-11   1.90636998259038E-11  -1.29078934497459E-18  -7.14809102782206E-03  -7.14809102825529E-03
      0.00000000000000E+00   0.00000000000000E+00   4.33222167216945E-10   0.00000000000000E+00   4.33222167216945E-10
      4.48088075468755E-18  -3.34376654282972E-01  -3.34234157168581E-01   0.00000000000000E+00  -1.92843327410034E-11
     -1.44401005113517E-22  -4.33001534301700E-10  -4.52285867042848E-10  -3.19009140971296E-18
      7.42239279731313E-09
      0.00000000000000E+00  -2.95648209071029E-13   0.00000000000000E+00   3.33320064076113E-13  -4.73880123917052E-23
      2.95310248953369E-10   2.95643569017398E-10  -1.27382961060232E-18  -1.71861196145160E-02  -1.71861196144777E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.83353806460162E-11   0.00000000000000E+00  -3.83353806460162E-11
      4.47896398565525E-18  -3.48773584075077E-01  -3.48692521382956E-01   0.00000000000000E+00  -5.11261931728129E-12
     -1.44910868758638E-22  -2.52195569053956E-10  -2.57308188371382E-10  -3.20513437505292E-18
      7.47239279731313E-09
      0.00000000000000E+00  -8.69126748194826E-13   0.00000000000000E+00   7.00935925952677E-13  -4.65562356095594E-23
      8.68435561536083E-10   8.69136497461989E-10  -1.22911706409991E-18  -4.29660096671731E-02  -4.29660096662075E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.65620518249157E-10   0.00000000000000E+00  -9.65620518249157E-10
      4.43068295974279E-18  -3.64224849143926E-01  -3.64255261802021E-01   0.00000000000000E+00   2.15965585692747E-11
     -1.43019289854811E-22   7.48874622180065E-11   9.64840207871381E-11  -3.20156589564287E-18
      7.52239279731313E-09
      0.00000000000000E+00  -1.25037425234327E-12   0.00000000000000E+00   5.29477264685952E-13  -4.55233589975442E-23
      1.24985515036971E-09   1.25038462763435E-09  -1.16842247321753E-18  -7.65509988574043E-02  -7.65509988558996E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.50471658992424E-09   0.00000000000000E+00  -1.50471658992424E-09
      4.35544713024658E-18  -3.79238448334651E-01  -3.79318599345187E-01   0.00000000000000E+00   3.43376985499500E-11
     -1.39869316977726E-22   2.19994263740123E-10   2.54331962289934E-10  -3.18702465702905E-18
      7.54739279731313E-09
      0.00000000000000E+00  -1.43975810046519E-12   0.00000000000000E+00   5.18276905366150E-13  -4.49654930919115E-23
      1.43924307870246E-09   1.43976135560778E-09  -1.13508113641730E-18  -9.43707486186974E-02  -9.43707486169924E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.70498759920430E-09   0.00000000000000E+00  -1.70498759920430E-09
      4.31282244026647E-18  -3.86390954146875E-01  -3.86474541030214E-01   0.00000000000000E+00   3.68922799772125E-11
     -1.38133881399676E-22   2.28333963619400E-10   2.65226243596475E-10  -3.17774130384916E-18
      7.58114279731313E-09
      0.00000000000000E+00  -1.67699305667223E-12   0.00000000000000E+00   4.79548404875646E-13  -4.39526597836988E-23
      1.67647977616884E-09   1.67695932457367E-09  -1.08816221162302E-18  -1.18712037921113E-01  -1.18712037919289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82339252170912E-09   0.00000000000000E+00  -1.82339252170912E-09
      4.25128294265879E-18  -3.95058829444133E-01  -3.95104996983748E-01   0.00000000000000E+00   3.78533365344629E-11
     -1.35578749965297E-22   1.08579860601155E-10   1.46433197135482E-10  -3.16312073103577E-18
      7.62670529731313E-09
      0.00000000000000E+00  -2.31614058289941E-12   0.00000000000000E+00   8.07802547431542E-13  -4.03055557970077E-23
      2.31538986457490E-09   2.31619766712229E-09  -1.02204663534314E-18  -1.51639444923482E-01  -1.51639444921478E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00425777917896E-09   0.00000000000000E+00  -2.00425777917896E-09
      4.15996394759494E-18  -4.03548497430521E-01  -4.03450271854537E-01   0.00000000000000E+00   4.01790344403889E-11
     -1.31513295659240E-22  -3.52118922383594E-10  -3.11939887943337E-10  -3.13791731225180E-18
      7.67670529731313E-09
      0.00000000000000E+00  -3.97733634477195E-12   0.00000000000000E+00   1.73303175680617E-12  -2.55013400388360E-23
      3.97565350100188E-09   3.97738653275866E-09  -9.47511922859586E-19  -1.86970813847321E-01  -1.86970813845008E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.31277921673580E-09   0.00000000000000E+00  -2.31277921673580E-09
      4.04432498675815E-18  -4.04163780370489E-01  -4.03639434112726E-01   0.00000000000000E+00   4.60480416343495E-11
     -1.26353121463335E-22  -1.71065535765705E-09  -1.66460731602282E-09  -3.09681306389857E-18
      7.72670529731313E-09
      0.00000000000000E+00  -6.88991665109703E-12   0.00000000000000E+00   2.93862521719350E-12   1.04351648835193E-23
      6.88696766602377E-09   6.88990629124098E-09  -8.81331596125558E-19  -2.16995822738684E-01  -2.16995822736116E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56802007191038E-09   0.00000000000000E+00  -2.56802007191038E-09
      3.91592398316263E-18  -3.87959505930710E-01  -3.86598023171399E-01   0.00000000000000E+00   5.21103100944863E-11
     -1.19388488936363E-22  -4.37399652942499E-09  -4.32188621933062E-09  -3.03459238703708E-18
      7.77670529731313E-09
      0.00000000000000E+00  -1.01276273271368E-11   0.00000000000000E+00   3.23453949045731E-12   5.37854583326237E-23
      1.01243617776234E-08   1.01275963171139E-08  -8.32309616001250E-19  -2.38831851669336E-01  -2.38831851666592E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74477328858671E-09   0.00000000000000E+00  -2.74477328858671E-09
      3.77868531873330E-18  -3.50204350465410E-01  -3.47878516626944E-01   0.00000000000000E+00   5.48249045873276E-11
     -1.11554819080833E-22  -7.43764793311442E-09  -7.38282302852720E-09  -2.94637570273204E-18
      7.82670529731313E-09
      0.00000000000000E+00  -1.22460261908284E-11   0.00000000000000E+00   2.11372176577056E-12   8.39204582509191E-23
      1.22438868043116E-08   1.22460005260774E-08  -8.00602808515500E-19  -2.53312759216052E-01  -2.53312759213184E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86813807262429E-09   0.00000000000000E+00  -2.86813807262429E-09
      3.63527841510208E-18  -2.94917167359945E-01  -2.91962742233666E-01   0.00000000000000E+00   5.02118388751032E-11
     -1.03764245056571E-22  -9.42807429232818E-09  -9.37786245345318E-09  -2.83467560658658E-18
      7.87670529731313E-09
      0.00000000000000E+00  -1.31360935391065E-11   0.00000000000000E+00   8.96880329169453E-13   9.66498703328398E-23
      1.31351350471690E-08   1.31360319274983E-08  -7.79563516132974E-19  -2.63538696912603E-01  -2.63538696909692E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91191648892223E-09   0.00000000000000E+00  -2.91191648892223E-09
      3.48968259065597E-18  -2.33697339613268E-01  -2.30476235057096E-01   0.00000000000000E+00   3.86866978837383E-11
     -9.57386187455788E-23  -1.02628021364597E-08  -1.02241154385761E-08  -2.71011907452300E-18
      7.92670529731313E-09
      0.00000000000000E+00  -1.33400807004444E-11   0.00000000000000E+00   2.11451944128854E-13   9.82294841698047E-23
      1.33398952555953E-08   1.33401067075395E-08  -7.63688241036631E-19  -2.71815735930485E-01  -2.71815735927587E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89787782319756E-09   0.00000000000000E+00  -2.89787782319756E-09
      3.34478869949609E-18  -1.73813263848474E-01  -1.70523384909580E-01   0.00000000000000E+00   2.78109875787810E-11
     -8.90917041634652E-23  -1.04700398719206E-08  -1.04422288843420E-08  -2.58110045845946E-18
      7.97670529731313E-09
      0.00000000000000E+00  -1.31813729945498E-11   0.00000000000000E+00  -1.48225646219735E-13   9.46958329042608E-23
      1.31814961884255E-08   1.31813479627794E-08  -7.50670169596450E-19  -2.79080625391277E-01  -2.79080625388414E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86263308805464E-09   0.00000000000000E+00  -2.86263308805464E-09
      3.20165704509336E-18  -1.17288746043397E-01  -1.14037741666481E-01   0.00000000000000E+00   2.03039035711819E-11
     -8.33352017278064E-23  -1.03390187782958E-08  -1.03187148747247E-08  -2.45098687549691E-18
      8.02670529731313E-09
      0.00000000000000E+00  -1.27285784401167E-11   0.00000000000000E+00  -4.38774109159076E-13   9.03141585891352E-23
      1.27289874071588E-08   1.27285486330498E-08  -7.37697087452595E-19  -2.86392074625782E-01  -2.86392074622986E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79604064307146E-09   0.00000000000000E+00  -2.79604064307146E-09
      3.06185501293979E-18  -6.82315872745693E-02  -6.51022331665403E-02   0.00000000000000E+00   1.42818016441989E-11
     -6.90533761235003E-23  -9.94678979162246E-09  -9.93250798997833E-09  -2.32415792548719E-18
      8.07670529731313E-09
      0.00000000000000E+00  -1.16314012094356E-11   0.00000000000000E+00  -1.06917023540881E-12   9.41240210425908E-23
      1.16324521672747E-08   1.16313829970394E-08  -7.17291581959319E-19  -2.96427366580464E-01  -2.96427366577834E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62982157436714E-09   0.00000000000000E+00  -2.62982157436714E-09
      2.93036393422143E-18  -3.55474684256057E-02  -3.27114034203255E-02   0.00000000000000E+00   9.12599426869232E-12
     -1.00757869736021E-23  -9.01068741694086E-09  -9.00156142267217E-09  -2.21307235226211E-18
      8.12670529731313E-09
      0.00000000000000E+00  -1.03191236042145E-11   0.00000000000000E+00  -1.27604300590811E-12   1.10466054153593E-22
      1.03203860508964E-08   1.03191100078906E-08  -6.86930851476524E-19  -3.09975658104880E-01  -3.09975658102473E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40690860466306E-09   0.00000000000000E+00  -2.40690860466306E-09
      2.81001850398828E-18  -2.01803354701691E-02  -1.76874793570744E-02   0.00000000000000E+00   5.50460141828740E-12
      7.40106598811018E-23  -7.91770600464590E-09  -7.91220140322754E-09  -2.12308765251176E-18
      8.17670529731313E-09
      0.00000000000000E+00  -9.45945686395201E-12   0.00000000000000E+00  -8.29385992056284E-13   1.29336953348076E-22
      9.46028748209238E-09   9.45945809610046E-09  -6.53439995991536E-19  -3.24522176544581E-01  -3.24522176542335E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.24612051488210E-09   0.00000000000000E+00  -2.24612051488210E-09
      2.69771247824417E-18  -1.35190631724399E-02  -1.12463895055288E-02   0.00000000000000E+00   3.42973530905930E-12
      1.40838698055873E-22  -7.21676731652757E-09  -7.21333758121837E-09  -2.04427248225264E-18
      8.22670529731313E-09
      0.00000000000000E+00  -8.96331159355695E-12   0.00000000000000E+00  -4.72442865488920E-13   1.42268612334884E-22
      8.96379636371019E-09   8.96332392084484E-09  -6.20718784383659E-19  -3.38721051230044E-01  -3.38721051227886E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15816611121634E-09   0.00000000000000E+00  -2.15816611121634E-09
      2.58980417268336E-18  -1.01991186178738E-02  -8.05504514020045E-03   0.00000000000000E+00   2.42216929224357E-12
      1.85629628709820E-22  -6.80757997892091E-09  -6.80515780962848E-09  -1.96908538829970E-18
      8.27670529731313E-09
      0.00000000000000E+00  -8.77356036648620E-12   0.00000000000000E+00  -1.68532570111140E-13   1.47799928174253E-22
      8.77370470111816E-09   8.77353616854820E-09  -5.87827785711946E-19  -3.53048165865466E-01  -3.53048165863261E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.20513295173235E-09   0.00000000000000E+00  -2.20513295173235E-09
      2.47954752509674E-18  -8.26001796181486E-03  -6.19053632199386E-03   0.00000000000000E+00   1.97054747724650E-12
      2.10781898926228E-22  -6.57037376429337E-09  -6.56840321681591E-09  -1.89171973938479E-18
      8.32670529731313E-09
      0.00000000000000E+00  -8.86246607210309E-12   0.00000000000000E+00   1.03806906543707E-13   1.46162813384267E-22
      8.86241858023344E-09   8.86252238714013E-09  -5.52433328119847E-19  -3.68442062154264E-01  -3.68442062151857E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40624192889654E-09   0.00000000000000E+00  -2.40624192889654E-09
      2.35923542865191E-18  -6.99204971223852E-03  -4.95789130102562E-03   0.00000000000000E+00   1.79156276796332E-12
      2.19399063531186E-22  -6.45807202101175E-09  -6.45628045824357E-09  -1.80680210053207E-18
      8.37670529731313E-09
      0.00000000000000E+00  -8.82141147457132E-12   0.00000000000000E+00  -2.56471475989639E-14   1.32935588077341E-22
      8.82139731751810E-09   8.82137167037064E-09  -5.17935649006592E-19  -3.83438248832033E-01  -3.83438248829611E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42134614783510E-09   0.00000000000000E+00  -2.42134614783510E-09
      2.23816812126016E-18  -6.09290649698086E-03  -4.07647020229229E-03   0.00000000000000E+00   1.55623135310291E-12
      2.05510904756402E-22  -6.40158175388884E-09  -6.40002552253553E-09  -1.72023247225357E-18
      8.40170529731313E-09
      0.00000000000000E+00  -8.73516926633345E-12   0.00000000000000E+00  -1.56294206986954E-13   1.22007929190914E-22
      8.73535590768885E-09   8.73519961348198E-09  -5.01470850461506E-19  -3.90587119156316E-01  -3.90587119153951E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36509503942974E-09   0.00000000000000E+00  -2.36509503942974E-09
      2.17904074527441E-18  -5.73100386420346E-03  -3.72399374196583E-03   0.00000000000000E+00   1.40593979512395E-12
      1.90256951526074E-22  -6.37151051384749E-09  -6.37010457405217E-09  -1.67756989481291E-18
      8.41858029731313E-09
      0.00000000000000E+00  -8.64975366073045E-12   0.00000000000000E+00  -2.36949469319916E-13   1.13315112129412E-22
      8.64999984567851E-09   8.64976289620931E-09  -4.90849491184968E-19  -3.95197233777748E-01  -3.95197233775460E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28849849822192E-09   0.00000000000000E+00  -2.28849849822192E-09
      2.14042233311692E-18  -5.52100152461893E-03  -3.51677604286254E-03   0.00000000000000E+00   1.27404572500726E-12
      1.77390596489883E-22  -6.36253844371266E-09  -6.36126439798747E-09  -1.64957284193195E-18
      8.44136154731313E-09
      0.00000000000000E+00  -8.49003566272657E-12   0.00000000000000E+00  -3.34295303490431E-13   1.00647691354009E-22
      8.49037871928968E-09   8.49004442398629E-09  -4.77694301704849E-19  -4.00907734945224E-01  -4.00907734943098E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12549870595781E-09   0.00000000000000E+00  -2.12549870595781E-09
      2.09200081572182E-18  -5.28018899283639E-03  -3.27492893132410E-03   0.00000000000000E+00   1.11003300979313E-12
      1.58034650712559E-22  -6.36565575103840E-09  -6.36454571802844E-09  -1.61430651401697E-18
      8.47211623481313E-09
      0.00000000000000E+00  -8.16830354828860E-12   0.00000000000000E+00  -5.06551313313017E-13   8.29128082941346E-23
      8.16885482461591E-09   8.16834827330268E-09  -4.63171096416915E-19  -4.07231980658799E-01  -4.07231980657019E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78003095074640E-09   0.00000000000000E+00  -1.78003095074640E-09
      2.03725652009128E-18  -5.02133829128125E-03  -3.00858766315439E-03   0.00000000000000E+00   8.51144251679757E-13
      1.30127228452063E-22  -6.38916846680812E-09  -6.38831732255631E-09  -1.57408542367437E-18
      8.51363506293813E-09
      0.00000000000000E+00  -7.34114984499761E-12   0.00000000000000E+00  -9.80488136295076E-13   5.96636355786723E-23
      7.34209011984192E-09   7.34110963170568E-09  -4.54913521375308E-19  -4.11030533996748E-01  -4.11030533995866E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.82200559174420E-10   0.00000000000000E+00  -8.82200559174420E-10
      2.00062858670314E-18  -4.78253332297067E-03  -2.74753977588494E-03   0.00000000000000E+00   2.94890405560627E-13
      9.26007528586156E-23  -6.45920396293694E-09  -6.45890907253128E-09  -1.54571506532783E-18
      8.56363506293813E-09
      0.00000000000000E+00  -5.27675568678403E-12   0.00000000000000E+00  -2.04297726891441E-12   3.31574267105152E-23
      5.27877959864938E-09   5.27673662138050E-09  -4.78738448752000E-19  -4.01810942325844E-01  -4.01810942327085E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24152918726490E-09   0.00000000000000E+00   1.24152918726490E-09
      2.06270504606639E-18  -4.64801742990953E-03  -2.59432280224522E-03   0.00000000000000E+00  -9.04757181854144E-13
      4.85622023525273E-23  -6.51736105146356E-09  -6.51826580864537E-09  -1.58396659731439E-18
      8.61363506293813E-09
      0.00000000000000E+00  -2.43269155441576E-12   0.00000000000000E+00  -2.83279759762845E-12   4.22101056910235E-24
      2.43548588171343E-09   2.43265308411580E-09  -5.53711185836327E-19  -3.72012646301666E-01  -3.72012646305731E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06503763570047E-09   0.00000000000000E+00   4.06503763570047E-09
      2.26595692785141E-18  -4.96569291749312E-03  -2.91848189081745E-03   0.00000000000000E+00  -3.03724173139762E-12
     -2.64901505337692E-24  -6.49465347808489E-09  -6.49769071981629E-09  -1.71224574201509E-18
      8.66363506293813E-09
      0.00000000000000E+00  -2.54593611539264E-13   0.00000000000000E+00  -2.21239250781701E-12  -2.55609328344440E-23
      2.56817471336315E-10   2.54605078828472E-10  -6.76706543230400E-19  -3.21977936832587E-01  -3.21977936838665E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07824536899954E-09   0.00000000000000E+00   6.07824536899954E-09
      2.56986919630139E-18  -7.43231994351545E-03  -5.43704707920894E-03   0.00000000000000E+00  -6.58490624485519E-12
     -5.61595738740571E-23  -6.32626554158309E-09  -6.33285044782800E-09  -1.89316265307099E-18
      8.71363506293814E-09
      0.00000000000000E+00   9.74472661771859E-13   0.00000000000000E+00  -1.31796486238978E-12  -3.94066869821128E-23
     -9.73127984535913E-10  -9.74445949398343E-10  -8.16314524189257E-19  -2.61039802618722E-01  -2.61039802625364E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64221232505073E-09   0.00000000000000E+00   6.64221232505073E-09
      2.90197981255392E-18  -1.92618719993412E-02  -1.74761483929487E-02   0.00000000000000E+00  -1.24726277907437E-11
     -7.81147314608363E-23  -5.65529374786162E-09  -5.66776637565244E-09  -2.08566528836467E-18
      8.76363506293814E-09
      0.00000000000000E+00   1.96106882885511E-12   0.00000000000000E+00  -1.11277058201722E-12  -4.27799792403080E-23
     -1.96000060496047E-09  -1.96111337554253E-09  -9.43897121352674E-19  -1.99945082609003E-01  -1.99945082615437E-01
      0.00000000000000E+00   0.00000000000000E+00   6.43376251477967E-09   0.00000000000000E+00   6.43376251477967E-09
      3.22366793829291E-18  -4.66431158221824E-02  -4.52339329949139E-02   0.00000000000000E+00  -2.25291020928795E-11
     -8.61841043877289E-23  -4.45012003714417E-09  -4.47264913923714E-09  -2.27977081694024E-18
      8.81363506293814E-09
      0.00000000000000E+00   2.17745502971604E-12   0.00000000000000E+00  -3.87915020774047E-13  -4.44355550047565E-23
     -2.17705350108483E-09  -2.17744141610565E-09  -1.05687660325799E-18  -1.41567754115478E-01  -1.41567754121302E-01
      0.00000000000000E+00   0.00000000000000E+00   5.82449141745207E-09   0.00000000000000E+00   5.82449141745207E-09
      3.51489250916551E-18  -8.07706371760212E-02  -7.96215707115868E-02   0.00000000000000E+00  -3.65065780868774E-11
     -9.57863621275279E-23  -3.61054342325943E-09  -3.64705000134640E-09  -2.45801590590752E-18
      8.83863506293814E-09
      0.00000000000000E+00   2.06880270559954E-12   0.00000000000000E+00   1.19536417047742E-14  -4.52505796460579E-23
     -2.06880406982611E-09  -2.06879211618445E-09  -1.10859877310606E-18  -1.13449132907938E-01  -1.13449132913287E-01
      0.00000000000000E+00   0.00000000000000E+00   5.34888287516961E-09   0.00000000000000E+00   5.34888287516961E-09
      3.64861458104475E-18  -9.87271767244887E-02  -9.76937218460909E-02   0.00000000000000E+00  -4.86821159769841E-11
     -1.00715238588622E-22  -3.23140864300807E-09  -3.28009075898515E-09  -2.54001580793869E-18
      8.87238506293814E-09
      0.00000000000000E+00   1.85223281526419E-12   0.00000000000000E+00   1.09401965337153E-13  -4.62609249491395E-23
     -1.85235251946542E-09  -1.85224311750013E-09  -1.16956858765698E-18  -7.90872291496433E-02  -7.90872291544176E-02
      0.00000000000000E+00   0.00000000000000E+00   4.77421718245500E-09   0.00000000000000E+00   4.77421718245500E-09
      3.80974441095261E-18  -1.23160534522375E-01  -1.22239910795271E-01   0.00000000000000E+00  -5.65664212716298E-11
     -1.07275852590601E-22  -2.86540764368311E-09  -2.92197406495485E-09  -2.64017582329563E-18
      8.91794756293814E-09
      0.00000000000000E+00   1.37179299493162E-12   0.00000000000000E+00   3.43178041017009E-13  -4.72461648587467E-23
     -1.37210194613973E-09  -1.37175876809876E-09  -1.22925380893751E-18  -4.41056081901183E-02  -4.41056081938895E-02
      0.00000000000000E+00   0.00000000000000E+00   3.77117879073784E-09   0.00000000000000E+00   3.77117879073784E-09
      3.98156874460560E-18  -1.56218542032992E-01  -1.55462559043252E-01   0.00000000000000E+00  -6.11601617508711E-11
     -1.15523695538045E-22  -2.33825986088812E-09  -2.39942002263910E-09  -2.75231493566810E-18
      8.96794756293814E-09
      0.00000000000000E+00   7.29247213427762E-13   0.00000000000000E+00   5.36501029988554E-13  -4.77498776679125E-23
     -7.29798955800394E-10  -7.29262454770454E-10  -1.26254982874234E-18  -2.39546847467697E-02  -2.39546847492438E-02
      0.00000000000000E+00   0.00000000000000E+00   2.47409439058807E-09   0.00000000000000E+00   2.47409439058807E-09
      4.10527346413500E-18  -1.91289152908791E-01  -1.90739409846605E-01   0.00000000000000E+00  -5.60940293024249E-11
     -1.22837727590743E-22  -1.68873790651506E-09  -1.74483193581761E-09  -2.84272363539267E-18
      9.01794756293814E-09
      0.00000000000000E+00   3.47724175067696E-13   0.00000000000000E+00   3.38619701332656E-13  -4.79292002449126E-23
     -3.48051796467909E-10  -3.47713176766624E-10  -1.27682355089652E-18  -1.52101831183789E-02  -1.52101831199397E-02
      0.00000000000000E+00   0.00000000000000E+00   1.56075694523826E-09   0.00000000000000E+00   1.56075694523826E-09
      4.18331131139692E-18  -2.20578729228201E-01  -2.20196536522303E-01   0.00000000000000E+00  -4.48913121231234E-11
     -1.28152702253646E-22  -1.16815245634840E-09  -1.21304376847165E-09  -2.90648776050040E-18
      9.06794756293814E-09
      0.00000000000000E+00   1.99762303426371E-13   0.00000000000000E+00   1.32693411438060E-13  -4.79931401078859E-23
     -1.99869949131709E-10  -1.99737255720319E-10  -1.28376163531363E-18  -1.10783770657062E-02  -1.10783770667406E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03440961651482E-09   0.00000000000000E+00   1.03440961651482E-09
      4.23503179222266E-18  -2.41625406981884E-01  -2.41362428871410E-01   0.00000000000000E+00  -3.21258194148445E-11
     -1.31718542569358E-22  -8.02546541379497E-10  -8.34672360794473E-10  -2.95127015690903E-18
      9.11794756293814E-09
      0.00000000000000E+00   1.43369634780949E-13   0.00000000000000E+00   5.12778395833531E-14  -4.80153146179796E-23
     -1.43416688195330E-10  -1.43365410355795E-10  -1.28793585168150E-18  -8.78097833818572E-03  -8.78097833890722E-03
      0.00000000000000E+00   0.00000000000000E+00   7.21501719617107E-10   0.00000000000000E+00   7.21501719617107E-10
      4.27110687820351E-18  -2.55506946486441E-01  -2.55324796683300E-01   0.00000000000000E+00  -2.09351224032780E-11
     -1.33953995047164E-22  -5.57201186857879E-10  -5.78136309261291E-10  -2.98317102652202E-18
      9.16794756293814E-09
      0.00000000000000E+00   1.16826505727974E-13   0.00000000000000E+00   2.56950694755411E-14  -4.80184747950304E-23
     -1.16863011513201E-10  -1.16837316443773E-10  -1.29083288784543E-18  -7.33195640296633E-03  -7.33195640352431E-03
      0.00000000000000E+00   0.00000000000000E+00   5.57978481679543E-10   0.00000000000000E+00   5.57978481679543E-10
      4.29900580228749E-18  -2.65383201136405E-01  -2.65244215419857E-01   0.00000000000000E+00  -1.43479676842450E-11
     -1.35446781762363E-22  -4.26793197551409E-10  -4.41141165235790E-10  -3.00817291444206E-18
      9.21794756293814E-09
      0.00000000000000E+00   1.01672124088732E-13   0.00000000000000E+00   1.64713576557415E-14  -4.80114664233693E-23
     -1.01664650674087E-10  -1.01648179316479E-10  -1.29301758290388E-18  -6.33030606535527E-03  -6.33030606583480E-03
      0.00000000000000E+00   0.00000000000000E+00   4.79532935814462E-10   0.00000000000000E+00   4.79532935814462E-10
      4.32298244907821E-18  -2.73477099247932E-01  -2.73358044256015E-01   0.00000000000000E+00  -1.12854831749745E-11
     -1.36594957043218E-22  -3.66599273322858E-10  -3.77884756497969E-10  -3.02996486617433E-18
      9.23044756293814E-09
      0.00000000000000E+00   9.81820240748461E-14   0.00000000000000E+00   1.57766120551738E-14  -4.80091122596461E-23
     -9.81549197607395E-11  -9.81391431487323E-11  -1.29352271948343E-18  -6.11019540589848E-03  -6.11019540634156E-03
      0.00000000000000E+00   0.00000000000000E+00   4.43077101238307E-10   0.00000000000000E+00   4.43077101238307E-10
      4.32852091284369E-18  -2.75227163841430E-01  -2.75118489685010E-01   0.00000000000000E+00  -9.44717634725621E-12
     -1.36834213181737E-22  -3.35490781742332E-10  -3.44937958089725E-10  -3.03499819336026E-18
      9.24732256293814E-09
      0.00000000000000E+00   9.30387187912246E-14   0.00000000000000E+00   1.75422416011109E-14  -4.80046777785480E-23
     -9.30431565296614E-11  -9.30256142881083E-11  -1.29412358211000E-18  -5.85904486920520E-03  -5.85904486963741E-03
      0.00000000000000E+00   0.00000000000000E+00   4.32212331816330E-10   0.00000000000000E+00   4.32212331816330E-10
      4.33581449594309E-18  -2.77582455593946E-01  -2.77475593493043E-01   0.00000000000000E+00  -9.32968855417514E-12
     -1.37149494380772E-22  -3.29857028973908E-10  -3.39186717528221E-10  -3.04169091383309E-18
      9.27010381293814E-09
      0.00000000000000E+00   8.89057056168859E-14   0.00000000000000E+00   1.19715876119929E-14  -4.79977302317056E-23
     -8.89172652931474E-11  -8.89052937055834E-11  -1.29485047968169E-18  -5.56475430189033E-03  -5.56475430231472E-03
      0.00000000000000E+00   0.00000000000000E+00   4.24391753421027E-10   0.00000000000000E+00   4.24391753421027E-10
      4.34548267057572E-18  -2.80756264062849E-01  -2.80650567837490E-01   0.00000000000000E+00  -9.26043993858590E-12
     -1.37568204922153E-22  -3.26226019776714E-10  -3.35486459715437E-10  -3.05063219089403E-18
      9.30085850043814E-09
      0.00000000000000E+00   8.39460898076795E-14   0.00000000000000E+00   1.15145813452405E-14  -4.79865918591637E-23
     -8.39460171765346E-11  -8.39345025952373E-11  -1.29569674666859E-18  -5.23597511420249E-03  -5.23597511462250E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20010482671534E-10   0.00000000000000E+00   4.20010482671534E-10
      4.35839996171701E-18  -2.85142757609820E-01  -2.85036875643813E-01   0.00000000000000E+00  -9.49464601200982E-12
     -1.38141072656517E-22  -3.26581334064132E-10  -3.36075980076280E-10  -3.06270321504841E-18
      9.34237732856314E-09
      0.00000000000000E+00   7.62311318822472E-14   0.00000000000000E+00   1.35026238182537E-14  -4.79674665333702E-23
     -7.62886048110293E-11  -7.62751021872590E-11  -1.29655645901172E-18  -4.91238005303736E-03  -4.91238005348436E-03
      0.00000000000000E+00   0.00000000000000E+00   4.46997717698449E-10   0.00000000000000E+00   4.46997717698449E-10
      4.37695878313039E-18  -2.92297163971718E-01  -2.92180365552545E-01   0.00000000000000E+00  -1.19902231530643E-11
     -1.39100308995092E-22  -3.58732392357964E-10  -3.70722615511168E-10  -3.08040232411867E-18
      9.39237732856314E-09
      0.00000000000000E+00   6.57608318405892E-14   0.00000000000000E+00   1.60293261962027E-14  -4.79373879649083E-23
     -6.57802707868299E-11  -6.57642414606817E-11  -1.29712627278444E-18  -4.68241484030355E-03  -4.68241484083100E-03
      0.00000000000000E+00   0.00000000000000E+00   5.27448027587533E-10   0.00000000000000E+00   5.27448027587533E-10
      4.40333118450977E-18  -3.04539352280477E-01  -3.04393893864094E-01   0.00000000000000E+00  -1.84269840725426E-11
     -1.40834753509756E-22  -4.43256802054177E-10  -4.61683786126860E-10  -3.10620491172533E-18
      9.44237732856314E-09
      0.00000000000000E+00   5.59334449593838E-14   0.00000000000000E+00   1.65038654818886E-14  -4.79010130068982E-23
     -5.59451843548416E-11  -5.59286804894076E-11  -1.29727042788269E-18  -4.63105632550289E-03  -4.63105632607077E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67879327890179E-10   0.00000000000000E+00   5.67879327890179E-10
      4.43172515090428E-18  -3.18912577971634E-01  -3.18751281560460E-01   0.00000000000000E+00  -2.26380791213038E-11
     -1.42912204541847E-22  -4.89312568279329E-10  -5.11950647400776E-10  -3.13445472302158E-18
      9.49237732856314E-09
      0.00000000000000E+00   2.92984711692010E-14   0.00000000000000E+00   3.69901897389748E-14  -4.78427341029143E-23
     -2.93507781250899E-11  -2.93137879353988E-11  -1.29615757427788E-18  -5.31485096246969E-03  -5.31485096299163E-03
      0.00000000000000E+00   0.00000000000000E+00   5.21941861386068E-10   0.00000000000000E+00   5.21941861386068E-10
      4.45782224397358E-18  -3.33321261099952E-01  -3.33166053026146E-01   0.00000000000000E+00  -2.21792682239722E-11
     -1.44897308396210E-22  -4.70448805226553E-10  -4.92628073450670E-10  -3.16166466969570E-18
      9.54237732856314E-09
      0.00000000000000E+00  -9.28550293168095E-14   0.00000000000000E+00   1.50585804515644E-13  -4.76756012347502E-23
      9.26833030153524E-11   9.28338888198204E-11  -1.28905544669443E-18  -9.55798608901064E-03  -9.55798608931125E-03
      0.00000000000000E+00   0.00000000000000E+00   3.00615592401556E-10   0.00000000000000E+00   3.00615592401556E-10
      4.47285302359366E-18  -3.47375096621986E-01  -3.47251138214245E-01   0.00000000000000E+00  -1.54166328652004E-11
     -1.46254972044284E-22  -3.78032848356033E-10  -3.93449481221379E-10  -3.18379757689923E-18
      9.59237732856314E-09
      0.00000000000000E+00  -5.44455602166219E-13   0.00000000000000E+00   5.42432002774168E-13  -4.71074954136784E-23
      5.43934342442922E-10   5.44476774445649E-10  -1.25977993992357E-18  -2.67248956681069E-02  -2.67248956676589E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.47991760147752E-10   0.00000000000000E+00  -4.47991760147752E-10
      4.45045343558627E-18  -3.62222772595741E-01  -3.62192383451825E-01   0.00000000000000E+00   7.45195982526440E-12
     -1.45640529387067E-22  -1.03936974123013E-10  -9.64850142978946E-11  -3.19067349566270E-18
      9.64237732856314E-09
      0.00000000000000E+00  -1.06567448581893E-12   0.00000000000000E+00   6.65649978241618E-13  -4.61360483225829E-23
      1.06499310716515E-09   1.06565875714335E-09  -1.20597528612752E-18  -5.72543584401615E-02  -5.72543584388954E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.26604673558450E-09   0.00000000000000E+00  -1.26604673558450E-09
      4.38715109880705E-18  -3.77619611124433E-01  -3.77682763608194E-01   0.00000000000000E+00   3.03722398863946E-11
     -1.42998882464781E-22   1.70015738554895E-10   2.00387978441147E-10  -3.18117581267953E-18
      9.65487732856314E-09
      0.00000000000000E+00  -1.21354451272305E-12   0.00000000000000E+00   7.35289312856663E-13  -4.58729036963202E-23
      1.21277788892665E-09   1.21351317823946E-09  -1.19086351722246E-18  -6.56165680564028E-02  -6.56165680549222E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.48054844563435E-09   0.00000000000000E+00  -1.48054844563435E-09
      4.36864424323662E-18  -3.81433783866529E-01  -3.81517936072790E-01   0.00000000000000E+00   3.46460977999922E-11
     -1.42227777453985E-22   2.32389169595052E-10   2.67035267394902E-10  -3.17778072601416E-18
      9.67175232856314E-09
      0.00000000000000E+00  -1.32026809735820E-12   0.00000000000000E+00   4.65277180013232E-13  -4.55110389643039E-23
      1.31984172696840E-09   1.32030700414836E-09  -1.16914769369148E-18  -7.74568819406348E-02  -7.74568819390216E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.61319285802322E-09   0.00000000000000E+00  -1.61319285802322E-09
      4.34142161375748E-18  -3.86482232976552E-01  -3.86574531699127E-01   0.00000000000000E+00   3.70718627219187E-11
     -1.41093538034488E-22   2.55813991153113E-10   2.92885853874891E-10  -3.17227392006599E-18
      9.68314295356314E-09
      0.00000000000000E+00  -1.39649922924044E-12   0.00000000000000E+00   4.78915738129024E-13  -4.52614275714513E-23
      1.39603611735060E-09   1.39651503308868E-09  -1.15392943313373E-18  -8.56411724175050E-02  -8.56411724158092E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.69582809657680E-09   0.00000000000000E+00  -1.69582809657680E-09
      4.32210507184491E-18  -3.89819996661729E-01  -3.89914321774608E-01   0.00000000000000E+00   3.81458724859018E-11
     -1.40292661904834E-22   2.61167191002180E-10   2.99313063487941E-10  -3.16817563871118E-18
      9.69852029731314E-09
      0.00000000000000E+00  -1.48329250590156E-12   0.00000000000000E+00   4.22843110942941E-13  -4.49118676671119E-23
      1.48283332229241E-09   1.48325616540331E-09  -1.13281419451962E-18  -9.68420053835854E-02  -9.68420053818215E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.76391954211342E-09   0.00000000000000E+00  -1.76391954211342E-09
      4.29498067469848E-18  -3.94170998660586E-01  -3.94259450345813E-01   0.00000000000000E+00   3.88480383782540E-11
     -1.39170499540607E-22   2.41815338332088E-10   2.80663376710203E-10  -3.16216648017887E-18
      9.71927971137564E-09
      0.00000000000000E+00  -1.61646737485247E-12   0.00000000000000E+00   4.53085792688221E-13  -4.43691645040033E-23
      1.61602956134293E-09   1.61648264713557E-09  -1.10362906354144E-18  -1.12040385847884E-01  -1.12040385846052E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83204616876622E-09   0.00000000000000E+00  -1.83204616876622E-09
      4.25694846969945E-18  -3.99679540032448E-01  -3.99747485676664E-01   0.00000000000000E+00   3.92458536501744E-11
     -1.37597328319201E-22   1.76317667980575E-10   2.15563521630611E-10  -3.15331940615801E-18
      9.74730492036001E-09
      0.00000000000000E+00  -1.88410293907520E-12   0.00000000000000E+00   5.96379116505876E-13  -4.32346822541108E-23
      1.88347900388159E-09   1.88407538299805E-09  -1.06324317653822E-18  -1.32550982528954E-01  -1.32550982527032E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.92240431719349E-09   0.00000000000000E+00  -1.92240431719349E-09
      4.20307268695764E-18  -4.06199888437012E-01  -4.06212004023344E-01   0.00000000000000E+00   3.99118053193753E-11
     -1.35347862040049E-22  -1.58287112380324E-12   3.83289341954367E-11  -3.13982951041943E-18
      9.78513895248892E-09
      0.00000000000000E+00  -2.58579673134071E-12   0.00000000000000E+00   1.02652314041870E-12  -3.93658905177654E-23
      2.58480960142765E-09   2.58583612456803E-09  -1.00655381600774E-18  -1.60358861785416E-01  -1.60358861783309E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10721842912576E-09   0.00000000000000E+00  -2.10721842912576E-09
      4.12334811720747E-18  -4.12204702340030E-01  -4.12053973019669E-01   0.00000000000000E+00   4.27706466185566E-11
     -1.31888008294583E-22  -5.21388342060762E-10  -4.78617695442337E-10  -3.11679430119973E-18
      9.83513895248892E-09
      0.00000000000000E+00  -4.49745309157817E-12   0.00000000000000E+00   1.97467317353039E-12  -2.29658191301758E-23
      4.49551256307679E-09   4.49748723625030E-09  -9.32295927165367E-19  -1.95136382417522E-01  -1.95136382415141E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.38085930355266E-09   0.00000000000000E+00  -2.38085930355266E-09
      4.00430515202984E-18  -4.09844743175646E-01  -4.09178001014222E-01   0.00000000000000E+00   4.89345019985041E-11
     -1.26130421861420E-22  -2.16556243469603E-09  -2.11662793269766E-09  -3.07200922486447E-18
      9.88513895248892E-09
      0.00000000000000E+00  -7.60336656972510E-12   0.00000000000000E+00   3.12337824053398E-12   1.26037160788462E-23
      7.60027678514304E-09   7.60340016338359E-09  -8.69001017037491E-19  -2.23578921155136E-01  -2.23578921152534E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60156090774849E-09   0.00000000000000E+00  -2.60156090774849E-09
      3.87422710664241E-18  -3.89258419212911E-01  -3.87682727681062E-01   0.00000000000000E+00   5.45238045780249E-11
     -1.18928095589056E-22  -5.05636306021298E-09  -5.00183925563508E-09  -3.00522608960492E-18
      9.93513895248892E-09
      0.00000000000000E+00  -1.07304961821670E-11   0.00000000000000E+00   3.12104009075979E-12   5.11564619579502E-23
      1.07273814698468E-08   1.07305025099376E-08  -8.23594476035314E-19  -2.43737514517687E-01  -2.43737514514925E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.76208953102554E-09   0.00000000000000E+00  -2.76208953102554E-09
      3.73612263009114E-18  -3.47183535517317E-01  -3.44673211221689E-01   0.00000000000000E+00   5.60772311999035E-11
     -1.10902932049732E-22  -8.02449021011191E-09  -7.96841297891212E-09  -2.91252815405582E-18
      9.98513895248892E-09
      0.00000000000000E+00  -1.25537979052108E-11   0.00000000000000E+00   1.82004896165754E-12   7.52474304706428E-23
      1.25519883074465E-08   1.25538083564082E-08  -7.94718731250105E-19  -2.56998802588103E-01  -2.56998802585231E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87282623684008E-09   0.00000000000000E+00  -2.87282623684008E-09
      3.59248131824913E-18  -2.89177149688784E-01  -2.86127219289867E-01   0.00000000000000E+00   4.98305464665223E-11
     -1.03008743867456E-22  -9.73081266603448E-09  -9.68098211956806E-09  -2.79776258699903E-18
      1.00351389524889E-08
      0.00000000000000E+00  -1.32414394526835E-11   0.00000000000000E+00   6.91662009044030E-13   8.40112492988395E-23
      1.32407784266671E-08   1.32414700886763E-08  -7.75179041336205E-19  -2.66589511323102E-01  -2.66589511320199E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90269819312306E-09   0.00000000000000E+00  -2.90269819312306E-09
      3.44734640859298E-18  -2.27241426010367E-01  -2.23984189635082E-01   0.00000000000000E+00   3.74105622536377E-11
     -9.48844927460802E-23  -1.03761824578067E-08  -1.03387718955532E-08  -2.67216736725678E-18
      1.00601389524889E-08
      0.00000000000000E+00  -1.32754220054503E-11   0.00000000000000E+00   7.72260297799983E-14   8.44465620889897E-23
      1.32753356064732E-08   1.32754128325031E-08  -7.67355712843998E-19  -2.70643145304503E-01  -2.70643145301590E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91255377973923E-09   0.00000000000000E+00  -2.91255377973923E-09
      3.37453256409950E-18  -1.96400663062680E-01  -1.93135807263547E-01   0.00000000000000E+00   2.95679925783560E-11
     -9.11699351136779E-23  -1.03924270453421E-08  -1.03628590527638E-08  -2.60717685125550E-18
      1.00938889524889E-08
      0.00000000000000E+00  -1.32539303369438E-11   0.00000000000000E+00  -2.32997215756894E-14   8.28379589967140E-23
      1.32539186892342E-08   1.32538953895127E-08  -7.57922321719500E-19  -2.75731935876146E-01  -2.75731935873261E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88432046377589E-09   0.00000000000000E+00  -2.88432046377589E-09
      3.27718674844706E-18  -1.56462055819492E-01  -1.53195052525124E-01   0.00000000000000E+00   2.39789605581010E-11
     -8.73148180260411E-23  -1.03935538862949E-08  -1.03695749257369E-08  -2.51926442672756E-18
      1.01052795774889E-08
      0.00000000000000E+00  -1.31598813260433E-11   0.00000000000000E+00  -3.98958285961459E-13   8.16187964348694E-23
      1.31602374007848E-08   1.31598384424989E-08  -7.55128175312957E-19  -2.77302949926373E-01  -2.77302949923485E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88802825207918E-09   0.00000000000000E+00  -2.88802825207918E-09
      3.24429030163822E-18  -1.43079986559087E-01  -1.39843774919282E-01   0.00000000000000E+00   2.13073181809062E-11
     -8.61635260108653E-23  -1.02931175086006E-08  -1.02718101904198E-08  -2.48916212632527E-18
      1.01206569212389E-08
      0.00000000000000E+00  -1.30764863046588E-11   0.00000000000000E+00  -2.60983890333023E-13   8.00401061982930E-23
      1.30767533945339E-08   1.30764924106437E-08  -7.51382889573944E-19  -2.79428436827931E-01  -2.79428436825060E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87017243145208E-09   0.00000000000000E+00  -2.87017243145208E-09
      3.20015467353801E-18  -1.25572799479142E-01  -1.22357209846578E-01   0.00000000000000E+00   1.92625593032440E-11
     -8.45247628235078E-23  -1.02255825384947E-08  -1.02063199791915E-08  -2.44877178396407E-18
      1.01414163353014E-08
      0.00000000000000E+00  -1.29492813436264E-11   0.00000000000000E+00  -2.95239219743835E-13   7.81732318406514E-23
      1.29495673642546E-08   1.29492721250349E-08  -7.46325180177503E-19  -2.82316108642766E-01  -2.82316108639923E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84295984461325E-09   0.00000000000000E+00  -2.84295984461325E-09
      3.14113649296062E-18  -1.03035424145282E-01  -9.98513295041211E-02   0.00000000000000E+00   1.70239603704262E-11
     -8.18796742300617E-23  -1.01233362407921E-08  -1.01063122804218E-08  -2.39481131278312E-18
      1.01694415442858E-08
      0.00000000000000E+00  -1.26989125899987E-11   0.00000000000000E+00  -4.32855930815238E-13   7.61762972880702E-23
      1.26993412858174E-08   1.26989084298866E-08  -7.39126851726763E-19  -2.86375578793710E-01  -2.86375578790912E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79806976592796E-09   0.00000000000000E+00  -2.79806976592796E-09
      3.06272000301763E-18  -7.52729537317268E-02  -7.21535804869588E-02   0.00000000000000E+00   1.41836858100266E-11
     -7.48200781404975E-23  -9.91502234976854E-09  -9.90083866395859E-09  -2.32359315129087E-18
      1.02072755764147E-08
      0.00000000000000E+00  -1.20344159163022E-11   0.00000000000000E+00  -8.55195455910419E-13   7.67782489723241E-23
      1.20352302184932E-08   1.20343750230374E-08  -7.26032667640304E-19  -2.93108154259177E-01  -2.93108154256486E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69110891802061E-09   0.00000000000000E+00  -2.69110891802061E-09
      2.96090450175085E-18  -4.59757897844814E-02  -4.30320714087113E-02   0.00000000000000E+00   1.05329255399363E-11
     -4.55934407381835E-23  -9.35379903055665E-09  -9.34326610501676E-09  -2.23487183411055E-18
      1.02572755764147E-08
      0.00000000000000E+00  -1.07770614639312E-11   0.00000000000000E+00  -1.22319474792310E-12   8.86120723065024E-23
      1.07783079445800E-08   1.07770847498322E-08  -6.98704957152895E-19  -3.05582874864602E-01  -3.05582874862125E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47640524222069E-09   0.00000000000000E+00  -2.47640524222069E-09
      2.83708423963982E-18  -2.49049329856225E-02  -2.22896840876367E-02   0.00000000000000E+00   6.61538152744271E-12
      2.78941014065191E-23  -8.30729488913899E-09  -8.30067950761152E-09  -2.13837928248693E-18
      1.03072755764147E-08
      0.00000000000000E+00  -9.74527768614183E-12   0.00000000000000E+00  -9.98855309792607E-13   1.06686267537153E-22
      9.74623737439620E-09   9.74523851908651E-09  -6.65572409623421E-19  -3.20001401950994E-01  -3.20001401948708E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28696989068813E-09   0.00000000000000E+00  -2.28696989068813E-09
      2.72273574510541E-18  -1.56506802734912E-02  -1.33008389321414E-02   0.00000000000000E+00   4.07549770653882E-12
      9.75493876009676E-23  -7.46234412610499E-09  -7.45826862839835E-09  -2.05716333548199E-18
      1.03572755764147E-08
      0.00000000000000E+00  -9.12146823102831E-12   0.00000000000000E+00  -5.97573308490740E-13   1.21960150208040E-22
      9.12209029040581E-09   9.12149271709744E-09  -6.32203769959437E-19  -3.34381884804164E-01  -3.34381884801998E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16508458306652E-09   0.00000000000000E+00  -2.16508458306652E-09
      2.61448151595209E-18  -1.13054975796723E-02  -9.11377134571731E-03   0.00000000000000E+00   2.74132538959977E-12
      1.47992752027860E-22  -6.95914945942071E-09  -6.95640813403096E-09  -1.98227774599265E-18
      1.04072755764147E-08
      0.00000000000000E+00  -8.78044872177677E-12   0.00000000000000E+00  -3.20266660521788E-13   1.30363657963695E-22
      8.78074331293895E-09   8.78042304627856E-09  -5.99732601636227E-19  -3.48413022155528E-01  -3.48413022153401E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12702356061789E-09   0.00000000000000E+00  -2.12702356061789E-09
      2.50813033792119E-18  -8.91267903277848E-03  -6.81641787244415E-03   0.00000000000000E+00   2.10436005767581E-12
      1.78939286908166E-22  -6.65550384571850E-09  -6.65339948566064E-09  -1.90839773628497E-18
      1.04572755764147E-08
      0.00000000000000E+00  -8.77346852174899E-12   0.00000000000000E+00   9.04707078948811E-15   1.32740260784455E-22
      8.77345967186371E-09   8.77346871893463E-09  -5.65353015151733E-19  -3.63271349105370E-01  -3.63271349103089E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28047623833654E-09   0.00000000000000E+00  -2.28047623833654E-09
      2.39410652600437E-18  -7.41617551568250E-03  -5.37045108408755E-03   0.00000000000000E+00   1.85191602677100E-12
      1.94778253140663E-22  -6.49484439662504E-09  -6.49299248059807E-09  -1.82875351085263E-18
      1.04822755764147E-08
      0.00000000000000E+00  -8.83941304306400E-12   0.00000000000000E+00   1.45994139097587E-13   1.31054120529342E-22
      8.83934186074835E-09   8.83948785488758E-09  -5.47402106691079E-19  -3.71002549556538E-01  -3.71002549554129E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40908965540899E-09   0.00000000000000E+00  -2.40908965540899E-09
      2.33387928461914E-18  -6.84977373454550E-03  -4.82376967429952E-03   0.00000000000000E+00   1.76184763653341E-12
      1.96564399017964E-22  -6.43216004711535E-09  -6.43039819947862E-09  -1.78647717792806E-18
      1.05160255764147E-08
      0.00000000000000E+00  -8.84317867728951E-12   0.00000000000000E+00   2.08850441675439E-14   1.24346032678529E-22
      8.84318274531373E-09   8.84320363035803E-09  -5.23352506470960E-19  -3.81363470377437E-01  -3.81363470374997E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44068918535989E-09   0.00000000000000E+00  -2.44068918535989E-09
      2.25150602461324E-18  -6.23233549505011E-03  -4.21511534194375E-03   0.00000000000000E+00   1.58966440252151E-12
      1.90538287761852E-22  -6.40410410940082E-09  -6.40251444499810E-09  -1.72815351814229E-18
      1.05388068264147E-08
      0.00000000000000E+00  -8.79422543235789E-12   0.00000000000000E+00  -9.15177432859650E-14   1.16802882850720E-22
      8.79433136311751E-09   8.79423984537434E-09  -5.07610462781175E-19  -3.88142928535441E-01  -3.88142928533027E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41388617495537E-09   0.00000000000000E+00  -2.41388617495537E-09
      2.19651468019004E-18  -5.87757147419416E-03  -3.86733257885710E-03   0.00000000000000E+00   1.48134571966884E-12
      1.80758945268728E-22  -6.38183501613888E-09  -6.38035367041903E-09  -1.68890421740887E-18
      1.05541841701647E-08
      0.00000000000000E+00  -8.73994519266825E-12   0.00000000000000E+00  -1.60514839346420E-13   1.10461514072001E-22
      8.74008410041890E-09   8.73992358557966E-09  -4.97303572754873E-19  -3.92580611839717E-01  -3.92580611837346E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.37083657289792E-09   0.00000000000000E+00  -2.37083657289792E-09
      2.16005751123352E-18  -5.66595566988131E-03  -3.65926595627459E-03   0.00000000000000E+00   1.38528560059720E-12
      1.71770401846406E-22  -6.37047229828245E-09  -6.36908701268168E-09  -1.66275393847865E-18
      1.05749435842272E-08
      0.00000000000000E+00  -8.63524219225167E-12   0.00000000000000E+00  -2.36008474776166E-13   1.00765212973332E-22
      8.63549030669811E-09   8.63525429822343E-09  -4.84133584404906E-19  -3.98249771081593E-01  -3.98249771079324E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26918975505561E-09   0.00000000000000E+00  -2.26918975505561E-09
      2.11295046152194E-18  -5.41853815364855E-03  -3.41279999696895E-03   0.00000000000000E+00   1.25200886118364E-12
      1.57390340661643E-22  -6.36731655202913E-09  -6.36606454316779E-09  -1.62881687711703E-18
      1.06029687932116E-08
      0.00000000000000E+00  -8.42950998090681E-12   0.00000000000000E+00  -3.50931853633589E-13   8.64474477094835E-23
      8.42988736651482E-09   8.42953643466127E-09  -4.68232675139873E-19  -4.05093415042633E-01  -4.05093415040573E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.06001976931239E-09   0.00000000000000E+00  -2.06001976931239E-09
      2.05521797697501E-18  -5.13929234103306E-03  -3.13246564014745E-03   0.00000000000000E+00   1.07356583334620E-12
      1.35321498092223E-22  -6.37059023118238E-09  -6.36951666534890E-09  -1.58698530183514E-18
      1.06408028253405E-08
      0.00000000000000E+00  -7.97607251331325E-12   0.00000000000000E+00  -5.82838578378709E-13   6.67689709578861E-23
      7.97672094450178E-09   7.97613810592346E-09  -4.52431276860165E-19  -4.11933248278680E-01  -4.11933248277110E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.56942544575270E-09   0.00000000000000E+00  -1.56942544575270E-09
      1.99584028423648E-18  -4.86005349287326E-03  -2.84150650033097E-03   0.00000000000000E+00   7.22695936841944E-13
      1.04019905812746E-22  -6.40743535610770E-09  -6.40671266017075E-09  -1.54340900737631E-18
      1.06908028253405E-08
      0.00000000000000E+00  -6.65378383173648E-12   0.00000000000000E+00  -1.30334288634357E-12   4.24496695780334E-23
      6.65506121467914E-09   6.65375787179284E-09  -4.53167051278953E-19  -4.12047085294637E-01  -4.12047085294472E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64898064407214E-10   0.00000000000000E+00  -1.64898064407214E-10
      1.98759538101612E-18  -4.63750918936129E-03  -2.59307937193656E-03   0.00000000000000E+00  -8.75763868642177E-14
      6.42948888748961E-23  -6.48877223099884E-09  -6.48885980738564E-09  -1.53442832973717E-18
      1.07408028253405E-08
      0.00000000000000E+00  -4.14770833229191E-12   0.00000000000000E+00  -2.50102386942889E-12   1.85046462137306E-23
      4.15019293445763E-09   4.14769191058822E-09  -4.95726505572941E-19  -3.95230215797053E-01  -3.95230215799429E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37528620433635E-09   0.00000000000000E+00   2.37528620433635E-09
      2.10635969123294E-18  -4.59405794531967E-03  -2.53887355416205E-03   0.00000000000000E+00  -1.57254931879710E-12
      2.36688187778520E-23  -6.52140556560577E-09  -6.52297811492454E-09  -1.61063318566000E-18
      1.07908028253405E-08
      0.00000000000000E+00  -1.38850873710339E-12   0.00000000000000E+00  -2.76172127560187E-12  -9.83613224790889E-24
      1.39122968245985E-09   1.38846796118423E-09  -5.91739468130341E-19  -3.56899427600122E-01  -3.56899427605198E-01
      0.00000000000000E+00   0.00000000000000E+00   5.07619138205538E-09   0.00000000000000E+00   5.07619138205538E-09
      2.36016926033571E-18  -5.32645712868279E-03  -3.28965351123904E-03   0.00000000000000E+00  -4.16675266500936E-12
     -2.74615436133042E-23  -6.46049259057458E-09  -6.46465934323962E-09  -1.76842979220537E-18
      1.08408028253405E-08
      0.00000000000000E+00   3.04832682791781E-13   0.00000000000000E+00  -1.75035520081654E-12  -3.32737204513315E-23
     -3.03067729041989E-10  -3.04818084242839E-10  -7.26784021121174E-19  -3.00909593589734E-01  -3.00909593596225E-01
      0.00000000000000E+00   0.00000000000000E+00   6.49110252914609E-09   0.00000000000000E+00   6.49110252914609E-09
      2.68472438679301E-18  -9.82864994070373E-03  -7.87955640415170E-03   0.00000000000000E+00  -8.40183300840190E-12
     -6.86128051440412E-23  -6.17788261189479E-09  -6.18628444490326E-09  -1.95794036567184E-18
      1.08908028253405E-08
      0.00000000000000E+00   1.42267497934459E-12   0.00000000000000E+00  -1.22162744167788E-12  -4.12212955268220E-23
     -1.42145927594271E-09  -1.42268090338443E-09  -8.64256408301463E-19  -2.38837160375099E-01  -2.38837160381759E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65970171013100E-09   0.00000000000000E+00   6.65970171013100E-09
      3.01770947229956E-18  -2.76497121949110E-02  -2.59997023484888E-02   0.00000000000000E+00  -1.56087700386502E-11
     -8.09292186786489E-23  -5.22141203670786E-09  -5.23702080674659E-09  -2.15345306399810E-18
      1.09158028253405E-08
      0.00000000000000E+00   1.86242758109423E-12   0.00000000000000E+00  -1.01467733200235E-12  -4.25610712595435E-23
     -1.86140325585978E-09  -1.86241793319183E-09  -9.28613053795705E-19  -2.07729321042212E-01  -2.07729321048632E-01
      0.00000000000000E+00   0.00000000000000E+00   6.41986991150352E-09   0.00000000000000E+00   6.41986991150352E-09
      3.17820622008715E-18  -4.11164586734647E-02  -3.96805549942389E-02   0.00000000000000E+00  -2.34234168506640E-11
     -8.48999777641864E-23  -4.53402856146093E-09  -4.55745197831168E-09  -2.24959316629145E-18
      1.09495528253405E-08
      0.00000000000000E+00   2.13107343742624E-12   0.00000000000000E+00  -5.58657557758482E-13  -4.37148663301188E-23
     -2.13053525135189E-09  -2.13109390890969E-09  -1.00825790738681E-18  -1.67374208865467E-01  -1.67374208871529E-01
      0.00000000000000E+00   0.00000000000000E+00   6.06222974669703E-09   0.00000000000000E+00   6.06222974669703E-09
      3.38280647403817E-18  -6.33813240067843E-02  -6.21427504001248E-02   0.00000000000000E+00  -3.20806785527632E-11
     -9.12524747835964E-23  -3.89905515923450E-09  -3.93113583778736E-09  -2.37454856665137E-18
      1.09723340753405E-08
      0.00000000000000E+00   2.13070605847741E-12   0.00000000000000E+00  -1.86468457400434E-13  -4.44591653037615E-23
     -2.13049021414123E-09  -2.13067668259868E-09  -1.05859639370113E-18  -1.40825100824814E-01  -1.40825100830518E-01
      0.00000000000000E+00   0.00000000000000E+00   5.70451556150258E-09   0.00000000000000E+00   5.70451556150258E-09
      3.51276246917366E-18  -7.94800689223682E-02  -7.83540646776888E-02   0.00000000000000E+00  -4.10493435163514E-11
     -9.57412477883379E-23  -3.53278953538746E-09  -3.57383887890390E-09  -2.45416607547253E-18
      1.09877114190905E-08
      0.00000000000000E+00   2.07615028457614E-12   0.00000000000000E+00  -2.53571448430822E-14  -4.49647220955700E-23
     -2.07611254436951E-09  -2.07613790151440E-09  -1.09085867627401E-18  -1.23364422567866E-01  -1.23364422573303E-01
      0.00000000000000E+00   0.00000000000000E+00   5.43760356483201E-09   0.00000000000000E+00   5.43760356483201E-09
      3.59637836836630E-18  -9.06341597047207E-02  -8.95750651145898E-02   0.00000000000000E+00  -4.74327242344074E-11
     -9.87917878743323E-23  -3.31403293908312E-09  -3.36146566331763E-09  -2.50551969209229E-18
      1.10084708331530E-08
      0.00000000000000E+00   1.97346786837813E-12   0.00000000000000E+00   3.73190487365420E-14  -4.56259343509156E-23
     -1.97347658533565E-09  -1.97343926628696E-09  -1.13135822673143E-18  -1.00931984782411E-01  -1.00931984787517E-01
      0.00000000000000E+00   0.00000000000000E+00   5.10657921279480E-09   0.00000000000000E+00   5.10657921279480E-09
      3.70238796068767E-18  -1.05842995864933E-01  -1.04855839114529E-01   0.00000000000000E+00  -5.28298979289641E-11
     -1.02885372154448E-22  -3.08031004857877E-09  -3.13313994650784E-09  -2.57102973395623E-18
      1.10364960421374E-08
      0.00000000000000E+00   1.77324634126572E-12   0.00000000000000E+00   1.45003077697850E-13  -4.64319181652868E-23
     -1.77341007214169E-09  -1.77326506906404E-09  -1.17964226765791E-18  -7.34196221120864E-02  -7.34196221167010E-02
      0.00000000000000E+00   0.00000000000000E+00   4.61466134688078E-09   0.00000000000000E+00   4.61466134688078E-09
      3.83171480932612E-18  -1.26385487727632E-01  -1.25490250313754E-01   0.00000000000000E+00  -5.87604298924602E-11
     -1.08339909671234E-22  -2.78263584792412E-09  -2.84139627781668E-09  -2.65207254166820E-18
      1.10743300742663E-08
      0.00000000000000E+00   1.35195453169479E-12   0.00000000000000E+00   3.72750903203308E-13  -4.72357223298056E-23
     -1.35229396348386E-09  -1.35192121258070E-09  -1.22844123554878E-18  -4.47207173145228E-02  -4.47207173182709E-02
      0.00000000000000E+00   0.00000000000000E+00   3.74802321951320E-09   0.00000000000000E+00   3.74802321951320E-09
      3.97351764023307E-18  -1.54224396825447E-01  -1.53469458234459E-01   0.00000000000000E+00  -6.19307243636700E-11
     -1.15230505381132E-22  -2.33417128256868E-09  -2.39610200693246E-09  -2.74507640468429E-18
      1.11243300742663E-08
      0.00000000000000E+00   7.36778481878780E-13   0.00000000000000E+00   5.08608207308526E-13  -4.77472675470127E-23
     -7.37270032784627E-10  -7.36761424577366E-10  -1.26209412955416E-18  -2.43481693215241E-02  -2.43481693240257E-02
      0.00000000000000E+00   0.00000000000000E+00   2.50160381633340E-09   0.00000000000000E+00   2.50160381633340E-09
      4.09859783104974E-18  -1.89679183917179E-01  -1.89123136198612E-01   0.00000000000000E+00  -5.63371948801374E-11
     -1.22605202682164E-22  -1.70850519687575E-09  -1.76484239175601E-09  -2.83650370149558E-18
      1.11743300742663E-08
      0.00000000000000E+00   3.54153306672223E-13   0.00000000000000E+00   3.38663991133642E-13  -4.79317023525855E-23
     -3.54473899054823E-10  -3.54135235063737E-10  -1.27667169459635E-18  -1.54074992999294E-02  -1.54074993015172E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58778238802114E-09   0.00000000000000E+00   1.58778238802114E-09
      4.17798695045079E-18  -2.19455437646064E-01  -2.19066753409293E-01   0.00000000000000E+00  -4.55241245670468E-11
     -1.28009125258153E-22  -1.18812302839023E-09  -1.23364715295740E-09  -2.90131525585444E-18
      1.12243300742663E-08
      0.00000000000000E+00   2.02793179754219E-13   0.00000000000000E+00   1.35563922683614E-13  -4.79976177454206E-23
     -2.02933533678491E-10  -2.02797969755855E-10  -1.28374673667698E-18  -1.11802962794091E-02  -1.11802962804635E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05436394631552E-09   0.00000000000000E+00   1.05436394631552E-09
      4.23070514776657E-18  -2.40990872303201E-01  -2.40722571454113E-01   0.00000000000000E+00  -3.28568903739949E-11
     -1.31659900137987E-22  -8.18709086185571E-10  -8.51565976559698E-10  -2.94695841108959E-18
      1.12743300742663E-08
      0.00000000000000E+00   1.44930995313477E-13   0.00000000000000E+00   5.26028639031842E-14  -4.80205597359542E-23
     -1.44955934363959E-10  -1.44903331500104E-10  -1.28798259405505E-18  -8.83775739075947E-03  -8.83775739149322E-03
      0.00000000000000E+00   0.00000000000000E+00   7.33749886370741E-10   0.00000000000000E+00   7.33749886370741E-10
      4.26739264208511E-18  -2.55201438604695E-01  -2.55015914269642E-01   0.00000000000000E+00  -2.14696344590950E-11
     -1.33952302582121E-22  -5.67376920411387E-10  -5.88846554870616E-10  -2.97941004803006E-18
      1.13243300742663E-08
      0.00000000000000E+00   1.17836797837257E-13   0.00000000000000E+00   2.61793265221763E-14  -4.80240770138687E-23
     -1.17830232215864E-10  -1.17804052889390E-10  -1.29091303229627E-18  -7.36683928980015E-03  -7.36683929036297E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62822168170443E-10   0.00000000000000E+00   5.62822168170443E-10
      4.29553375049363E-18  -2.65184086471668E-01  -2.65043879238336E-01   0.00000000000000E+00  -1.45371025603502E-11
     -1.35464544387328E-22  -4.30481012720576E-10  -4.45018115281062E-10  -3.00462071819736E-18
      1.13493300742663E-08
      0.00000000000000E+00   1.06539895160731E-13   0.00000000000000E+00   2.32521206841197E-14  -4.80216470322281E-23
     -1.06569627953255E-10  -1.06546375832619E-10  -1.29210866501337E-18  -6.80844734762612E-03  -6.80844734812224E-03
      0.00000000000000E+00   0.00000000000000E+00   4.96130153616251E-10   0.00000000000000E+00   4.96130153616251E-10
      4.30793700433404E-18  -2.69363125834971E-01  -2.69240384715633E-01   0.00000000000000E+00  -1.17588240900624E-11
     -1.36067402864423E-22  -3.77824953693422E-10  -3.89583777783620E-10  -3.01582833932066E-18
      1.13830800742663E-08
      0.00000000000000E+00   9.86412477608837E-14   0.00000000000000E+00   1.34592738735302E-14  -4.80153486840906E-23
     -9.86966232232487E-11  -9.86831639494232E-11  -1.29347872041223E-18  -6.19917282916586E-03  -6.19917282962885E-03
      0.00000000000000E+00   0.00000000000000E+00   4.62991579800815E-10   0.00000000000000E+00   4.62991579800815E-10
      4.32356297015231E-18  -2.74563831017987E-01  -2.74449053632408E-01   0.00000000000000E+00  -1.06100618416323E-11
     -1.36790879608150E-22  -3.53698354009706E-10  -3.64308415851475E-10  -3.03008424974008E-18
      1.14058613242663E-08
      0.00000000000000E+00   9.38653214260923E-14   0.00000000000000E+00   1.28587030594709E-14  -4.80097331506176E-23
     -9.39089316949010E-11  -9.38960729918895E-11  -1.29430401907109E-18  -5.84904540418017E-03  -5.84904540461797E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37804537874567E-10   0.00000000000000E+00   4.37804537874567E-10
      4.33353670478077E-18  -2.77803678189297E-01  -2.77695328401848E-01   0.00000000000000E+00  -9.57403423382650E-12
     -1.37227549926044E-22  -3.34334430648637E-10  -3.43908464882600E-10  -3.03923268570968E-18
      1.14212386680163E-08
      0.00000000000000E+00   9.05589108866214E-14   0.00000000000000E+00   1.34860237818548E-14  -4.80052773847728E-23
     -9.06011315873263E-11  -9.05876455635925E-11  -1.29481456713427E-18  -5.64016962352790E-03  -5.64016962395267E-03
      0.00000000000000E+00   0.00000000000000E+00   4.24770763823837E-10   0.00000000000000E+00   4.24770763823837E-10
      4.34006855083104E-18  -2.79913972879932E-01  -2.79808687339578E-01   0.00000000000000E+00  -9.11538828780515E-12
     -1.37506241152908E-22  -3.25067729972337E-10  -3.34183118260279E-10  -3.04525398369677E-18
      1.14419980820788E-08
      0.00000000000000E+00   8.67014319239053E-14   0.00000000000000E+00   1.24417308645749E-14  -4.79983136287756E-23
     -8.67519704603475E-11  -8.67395287295309E-11  -1.29543194435646E-18  -5.39593240324432E-03  -5.39593240366399E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19669289180299E-10   0.00000000000000E+00   4.19669289180299E-10
      4.34878063937445E-18  -2.82793627175877E-01  -2.82688736534797E-01   0.00000000000000E+00  -9.19602805137137E-12
     -1.37882395330997E-22  -3.23733732399236E-10  -3.32929760450745E-10  -3.05334869501799E-18
      1.14700232910631E-08
      0.00000000000000E+00   8.22010398007364E-14   0.00000000000000E+00   1.17712978209600E-14  -4.79874458185791E-23
     -8.22028347882671E-11  -8.21910634904942E-11  -1.29615293937930E-18  -5.12047685757246E-03  -5.12047685799365E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21190843117890E-10   0.00000000000000E+00   4.21190843117890E-10
      4.36058460077513E-18  -2.86879106075771E-01  -2.86772302894608E-01   0.00000000000000E+00  -9.75945733897769E-12
     -1.38415448143268E-22  -3.29240322288319E-10  -3.38999779627435E-10  -3.06443166139583E-18
      1.15078573231921E-08
      0.00000000000000E+00   7.49453055613418E-14   0.00000000000000E+00   1.40840225507392E-14  -4.79691627284039E-23
     -7.49314882493935E-11  -7.49174042268907E-11  -1.29688108626947E-18  -4.84574424645796E-03  -4.84574424691550E-03
      0.00000000000000E+00   0.00000000000000E+00   4.57545127914044E-10   0.00000000000000E+00   4.57545127914044E-10
      4.37789537784505E-18  -2.93758781809739E-01  -2.93638232334114E-01   0.00000000000000E+00  -1.28336976267581E-11
     -1.39345799973941E-22  -3.69794026060268E-10  -3.82627723687166E-10  -3.08101429157559E-18
      1.15578573231921E-08
      0.00000000000000E+00   6.49342292057214E-14   0.00000000000000E+00   1.55761995224673E-14  -4.79385162159183E-23
     -6.49887248298120E-11  -6.49731486303375E-11  -1.29740719247618E-18  -4.62682602597920E-03  -4.62682602651657E-03
      0.00000000000000E+00   0.00000000000000E+00   5.37360408824552E-10   0.00000000000000E+00   5.37360408824552E-10
      4.40476339828628E-18  -3.06415460487125E-01  -3.06266629646652E-01   0.00000000000000E+00  -1.92339478316250E-11
     -1.41148398998772E-22  -4.53153312362450E-10  -4.72387260194216E-10  -3.10735620581010E-18
      1.16078573231921E-08
      0.00000000000000E+00   5.53823765361386E-14   0.00000000000000E+00   1.64120029715028E-14  -4.79016949538961E-23
     -5.53284037394272E-11  -5.53119917365036E-11  -1.29751667372985E-18  -4.59079794350607E-03  -4.59079794407497E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68894889660538E-10   0.00000000000000E+00   5.68894889660538E-10
      4.43320814276931E-18  -3.20867587095640E-01  -3.20705776429600E-01   0.00000000000000E+00  -2.28814880734521E-11
     -1.43239020551703E-22  -4.90701409850397E-10  -5.13582897923992E-10  -3.13569146903946E-18
      1.16578573231921E-08
      0.00000000000000E+00   2.64512843157677E-14   0.00000000000000E+00   3.96163957303766E-14  -4.78409070696952E-23
     -2.65319516638292E-11  -2.64923352681467E-11  -1.29625965842897E-18  -5.35954206076515E-03  -5.35954206128057E-03
      0.00000000000000E+00   0.00000000000000E+00   5.15415858221999E-10   0.00000000000000E+00   5.15415858221999E-10
      4.45897893568041E-18  -3.35218842896320E-01  -3.35064802099203E-01   0.00000000000000E+00  -2.20332193029051E-11
     -1.45202688806334E-22  -4.66890303650826E-10  -4.88923522953876E-10  -3.16271927725144E-18
      1.17078573231921E-08
      0.00000000000000E+00  -1.07642032007221E-13   0.00000000000000E+00   1.64822877920378E-13  -4.76603500566365E-23
      1.07523980408294E-10   1.07688803286166E-10  -1.28841761647582E-18  -1.00400906704512E-02  -1.00400906707253E-02
      0.00000000000000E+00   0.00000000000000E+00   2.74073279550349E-10   0.00000000000000E+00   2.74073279550349E-10
      4.47268259965792E-18  -3.49238046093402E-01  -3.49117770244566E-01   0.00000000000000E+00  -1.45846044159257E-11
     -1.46483444198518E-22  -3.67177478420440E-10  -3.81762082836512E-10  -3.18426498318211E-18
      1.17578573231921E-08
      0.00000000000000E+00  -5.82479323370135E-13   0.00000000000000E+00   5.70458888783720E-13  -4.70592389299131E-23
      5.81902428011571E-10   5.82472886900308E-10  -1.25728046778582E-18  -2.82725344666832E-02  -2.82725344661728E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.10423405467708E-10   0.00000000000000E+00  -5.10423405467708E-10
      4.44716142938454E-18  -3.64131782724646E-01  -3.64109092953091E-01   0.00000000000000E+00   9.40885187710070E-12
     -1.45702195046791E-22  -8.14583333095732E-11  -7.20494814326183E-11  -3.18988096159872E-18
      1.17828573231921E-08
      0.00000000000000E+00  -9.20008732607795E-13   0.00000000000000E+00   8.05498371320831E-13  -4.66169009443568E-23
      9.19170939224211E-10   9.19976437595486E-10  -1.23354237055537E-18  -4.18884077404924E-02  -4.18884077394422E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.05015661262699E-09   0.00000000000000E+00  -1.05015661262699E-09
      4.42090751406887E-18  -3.71863166614242E-01  -3.71904196787165E-01   0.00000000000000E+00   2.48651935083209E-11
     -1.44639174541500E-22   1.05314981523288E-10   1.30180175031464E-10  -3.18736514351350E-18
      1.18166073231921E-08
      0.00000000000000E+00  -1.18672584945845E-12   0.00000000000000E+00   5.46523205954658E-13  -4.59164179791918E-23
      1.18613872194383E-09   1.18668524514974E-09  -1.19354706887414E-18  -6.42458815832170E-02  -6.42458815817715E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.44550846208708E-09   0.00000000000000E+00  -1.44550846208708E-09
      4.37212160347343E-18  -3.82196373441458E-01  -3.82277938438534E-01   0.00000000000000E+00   3.46427345234728E-11
     -1.42583448199079E-22   2.24180482413970E-10   2.58823216937300E-10  -3.17857453459929E-18
      1.18393885731921E-08
      0.00000000000000E+00  -1.34231083428800E-12   0.00000000000000E+00   4.90193440070853E-13  -4.54224266993596E-23
      1.34186107912636E-09   1.34235127256639E-09  -1.16392471161295E-18  -8.03750949552231E-02  -8.03750949535849E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.63823717533883E-09   0.00000000000000E+00  -1.63823717533883E-09
      4.33480051282274E-18  -3.88948141970368E-01  -3.89041386647182E-01   0.00000000000000E+00   3.79244187819785E-11
     -1.41019760250241E-22   2.57961483990679E-10   2.95885902772517E-10  -3.17087580120979E-18
      1.18547659169421E-08
      0.00000000000000E+00  -1.44288082153025E-12   0.00000000000000E+00   4.70063913740786E-13  -4.50796635454996E-23
      1.44244253064803E-09   1.44291259456172E-09  -1.14303175192142E-18  -9.15397428469663E-02  -9.15397428452288E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73744530270061E-09   0.00000000000000E+00  -1.73744530270061E-09
      4.30808321915629E-18  -3.93363323489360E-01  -3.93456143880844E-01   0.00000000000000E+00   3.89908075355691E-11
     -1.39909001558388E-22   2.55541900603588E-10   2.94532708139018E-10  -3.16505146723487E-18
      1.18755253310046E-08
      0.00000000000000E+00  -1.56696306149761E-12   0.00000000000000E+00   4.34920562352736E-13  -4.45743989641991E-23
      1.56653137980751E-09   1.56696630036982E-09  -1.11402993499620E-18  -1.06752883279744E-01  -1.06752883277931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81261903715599E-09   0.00000000000000E+00  -1.81261903715599E-09
      4.27045431002640E-18  -3.98994473343018E-01  -3.99071897406888E-01   0.00000000000000E+00   3.95174851311716E-11
     -1.38347977002296E-22   2.06135251655140E-10   2.45652736786174E-10  -3.15642437503019E-18
      1.19035505399889E-08
      0.00000000000000E+00  -1.80171820980005E-12   0.00000000000000E+00   5.41970728716954E-13  -4.36094508780643E-23
      1.80116258130293E-09   1.80170455203161E-09  -1.07387018632808E-18  -1.27298531261424E-01  -1.27298531259524E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89945805185862E-09   0.00000000000000E+00  -1.89945805185862E-09
      4.21722160116601E-18  -4.05766794637863E-01  -4.05797629808106E-01   0.00000000000000E+00   4.00274088135970E-11
     -1.36127322628259E-22   5.77260910135856E-11   9.77534998270465E-11  -3.14335141483793E-18
      1.19413845721178E-08
      0.00000000000000E+00  -2.41248571223011E-12   0.00000000000000E+00   9.11087939135270E-13  -4.05009112442954E-23
      2.41154481768871E-09   2.41245590562780E-09  -1.01751981985643E-18  -1.55148264737751E-01  -1.55148264735682E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.06924307521638E-09   0.00000000000000E+00  -2.06924307521638E-09
      4.13893379217576E-18  -4.12432809278839E-01  -4.12324735030754E-01   0.00000000000000E+00   4.24051621669599E-11
     -1.32755715695790E-22  -3.85617992578253E-10  -3.43212830411426E-10  -3.12141397231932E-18
      1.19913845721178E-08
      0.00000000000000E+00  -4.14192211384783E-12   0.00000000000000E+00   1.79910199654009E-12  -2.66769022344966E-23
      4.14010996301457E-09   4.14190906501108E-09  -9.42519032226627E-19  -1.90523753741951E-01  -1.90523753739605E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34542471232806E-09   0.00000000000000E+00  -2.34542471232806E-09
      4.02166255655935E-18  -4.12031714996623E-01  -4.11465827820170E-01   0.00000000000000E+00   4.82917336692996E-11
     -1.27181694186589E-22  -1.84477608635222E-09  -1.79648435268305E-09  -3.07914352433272E-18
      1.20413845721178E-08
      0.00000000000000E+00  -7.12402888623902E-12   0.00000000000000E+00   3.00534013374505E-12   6.31235274625707E-24
      7.12101576393654E-09   7.12402110407029E-09  -8.76965024549055E-19  -2.20111513307787E-01  -2.20111513305211E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57631900362669E-09   0.00000000000000E+00  -2.57631900362669E-09
      3.89284660637802E-18  -3.94412557353953E-01  -3.92979939609811E-01   0.00000000000000E+00   5.40827101279945E-11
     -1.20160286257235E-22  -4.60178481057149E-09  -4.54770210044362E-09  -3.01588158182896E-18
      1.20913845721178E-08
      0.00000000000000E+00  -1.03552185859370E-11   0.00000000000000E+00   3.22647844949463E-12   4.56148567180635E-23
      1.03519666314343E-08   1.03551931098838E-08  -8.28862326657712E-19  -2.41443830591181E-01  -2.41443830588439E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74181418983573E-09   0.00000000000000E+00  -2.74181418983573E-09
      3.75575589688623E-18  -3.55261079163057E-01  -3.52862614991376E-01   0.00000000000000E+00   5.64880217735949E-11
     -1.12147819165432E-22  -7.66986694182159E-09  -7.61337892004811E-09  -2.92689357022852E-18
      1.21413845721178E-08
      0.00000000000000E+00  -1.23929777703604E-11   0.00000000000000E+00   2.03333641704269E-12   7.20796487471407E-23
      1.23909862226601E-08   1.23930195590772E-08  -7.97988394880119E-19  -2.55507795014794E-01  -2.55507795011933E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86102454642640E-09   0.00000000000000E+00  -2.86102454642640E-09
      3.61270466956491E-18  -2.98778780127085E-01  -2.95775799054479E-01   0.00000000000000E+00   5.14475868620342E-11
     -1.04228218028329E-22  -9.58344259951269E-09  -9.53199501265076E-09  -2.81471627468479E-18
      1.21913845721178E-08
      0.00000000000000E+00  -1.31922106735403E-11   0.00000000000000E+00   8.02475291308632E-13   8.25027089680854E-23
      1.31914082799543E-08   1.31922107552457E-08  -7.77584424975308E-19  -2.65425133564574E-01  -2.65425133561672E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90297834568589E-09   0.00000000000000E+00  -2.90297834568589E-09
      3.46755575228061E-18  -2.36673438997503E-01  -2.33431819940808E-01   0.00000000000000E+00   3.94259213293869E-11
     -9.60811414795911E-23  -1.03286583308891E-08  -1.02892324095598E-08  -2.68997132730531E-18
      1.22163845721178E-08
      0.00000000000000E+00  -1.32652272396203E-11   0.00000000000000E+00   1.54772195896429E-13   8.35527885994000E-23
      1.32650566896048E-08   1.32652114618007E-08  -7.69471378132962E-19  -2.69583443267832E-01  -2.69583443264916E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91598855251559E-09   0.00000000000000E+00  -2.91598855251559E-09
      3.39465603846773E-18  -2.05603505516020E-01  -2.02342954049511E-01   0.00000000000000E+00   3.11488676934447E-11
     -9.21629669198333E-23  -1.03803717769785E-08  -1.03492229092852E-08  -2.62518466033476E-18
      1.22501345721178E-08
      0.00000000000000E+00  -1.32750546265015E-11   0.00000000000000E+00   2.28657841928726E-14   8.23812416422784E-23
      1.32750483498399E-08   1.32750712156242E-08  -7.59764901713728E-19  -2.74765971854410E-01  -2.74765971851521E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88897823771291E-09   0.00000000000000E+00  -2.88897823771291E-09
      3.29715302294491E-18  -1.65320709543643E-01  -1.62048508546623E-01   0.00000000000000E+00   2.51452286409245E-11
     -8.80741100263907E-23  -1.04112382065521E-08  -1.03860929779113E-08  -2.53738812123119E-18
      1.22729158221178E-08
      0.00000000000000E+00  -1.31667696813338E-11   0.00000000000000E+00  -2.26817683630364E-13   8.03972729953349E-23
      1.31669911862956E-08   1.31667643686121E-08  -7.53959550372559E-19  -2.77998082176613E-01  -2.77998082173736E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87676035323476E-09   0.00000000000000E+00  -2.87676035323476E-09
      3.23161682614778E-18  -1.38838567752997E-01  -1.35596621374207E-01   0.00000000000000E+00   2.12159400301022E-11
     -8.57406950535417E-23  -1.03112199554074E-08  -1.02900040153773E-08  -2.47765727577523E-18
      1.22882931658678E-08
      0.00000000000000E+00  -1.30605971651219E-11   0.00000000000000E+00  -3.33382909491198E-13   7.87840509535741E-23
      1.30609679063357E-08   1.30606345234263E-08  -7.50263431119161E-19  -2.80105413977527E-01  -2.80105413974662E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86519499031601E-09   0.00000000000000E+00  -2.86519499031601E-09
      3.18755773787092E-18  -1.21436054184528E-01  -1.18223889920202E-01   0.00000000000000E+00   1.88711391387058E-11
     -8.40764672106439E-23  -1.02143106722488E-08  -1.01954395331102E-08  -2.43729430675176E-18
      1.23090525799303E-08
      0.00000000000000E+00  -1.29226463698362E-11   0.00000000000000E+00  -3.21082575025607E-13   7.68976769189507E-23
      1.29229175820944E-08   1.29225964995194E-08  -7.45231880423898E-19  -2.82984954476316E-01  -2.82984954473479E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83738145407678E-09   0.00000000000000E+00  -2.83738145407678E-09
      3.12865536141248E-18  -9.91090849974260E-02  -9.59316349439693E-02   0.00000000000000E+00   1.65895681185405E-11
     -8.12768651829261E-23  -1.01018046135611E-08  -1.00852150454426E-08  -2.38342348098858E-18
      1.23370777889147E-08
      0.00000000000000E+00  -1.26487653634834E-11   0.00000000000000E+00  -4.73967303769413E-13   7.49985249954856E-23
      1.26492543842314E-08   1.26487804169277E-08  -7.37925365292769E-19  -2.87085468630747E-01  -2.87085468627957E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78957326921543E-09   0.00000000000000E+00  -2.78957326921543E-09
      3.05047698756549E-18  -7.18289605986661E-02  -6.87227019640591E-02   0.00000000000000E+00   1.37639716857893E-11
     -7.32480718061003E-23  -9.87297111939800E-09  -9.85920714771229E-09  -2.31255162227272E-18
      1.23749118210436E-08
      0.00000000000000E+00  -1.19358665132786E-11   0.00000000000000E+00  -9.17626983855486E-13   7.62242856728939E-23
      1.19368705097576E-08   1.19359528827738E-08  -7.24234506865243E-19  -2.94033013626919E-01  -2.94033013624245E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67478910083971E-09   0.00000000000000E+00  -2.67478910083971E-09
      2.94927893078627E-18  -4.36596958029043E-02  -4.07418435790813E-02   0.00000000000000E+00   1.01490661600722E-11
     -4.13422578075240E-23  -9.27131284809412E-09  -9.26116378193409E-09  -2.22504442392103E-18
      1.24249118210436E-08
      0.00000000000000E+00  -1.06777773030099E-11   0.00000000000000E+00  -1.22368129670228E-12   8.88627193292792E-23
      1.06790255652239E-08   1.06778018839273E-08  -6.96153240719555E-19  -3.06767991694962E-01  -3.06767991692504E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45795255376251E-09   0.00000000000000E+00  -2.45795255376251E-09
      2.82638130309815E-18  -2.38796075075261E-02  -2.12898246496395E-02   0.00000000000000E+00   6.34700269972128E-12
      3.28575755875834E-23  -8.22619633286453E-09  -8.21984933016478E-09  -2.13022806237859E-18
      1.24749118210436E-08
      0.00000000000000E+00  -9.68484384905928E-12   0.00000000000000E+00  -9.60485780816328E-13   1.06912282000837E-22
      9.68583588713556E-09   9.68487540135485E-09  -6.62845580221938E-19  -3.21234036415474E-01  -3.21234036413200E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27392940442365E-09   0.00000000000000E+00  -2.27392940442365E-09
      2.71268483287696E-18  -1.52007586125984E-02  -1.28658266144097E-02   0.00000000000000E+00   3.92976214849553E-12
      1.00740260817331E-22  -7.41487575907980E-09  -7.41094599693121E-09  -2.04983925265503E-18
      1.25249118210436E-08
      0.00000000000000E+00  -9.08564878351738E-12   0.00000000000000E+00  -5.73532884418104E-13   1.21657744841402E-22
      9.08620584213887E-09   9.08563230925457E-09  -6.29555507167283E-19  -3.35574301807132E-01  -3.35574301804976E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15656994580287E-09   0.00000000000000E+00  -2.15656994580287E-09
      2.60485633558682E-18  -1.10725359174225E-02  -8.88942515592731E-03   0.00000000000000E+00   2.67240817879856E-12
      1.49347436543170E-22  -6.93173477163062E-09  -6.92906236345168E-09  -1.97530082841954E-18
      1.25749118210436E-08
      0.00000000000000E+00  -8.76400851381662E-12   0.00000000000000E+00  -3.01129747760339E-13   1.29506471117175E-22
      8.76435716184406E-09   8.76405603209643E-09  -5.97096971082263E-19  -3.49596534446047E-01  -3.49596534443921E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12657853341348E-09   0.00000000000000E+00  -2.12657853341348E-09
      2.49852740891615E-18  -8.77255288997347E-03  -6.68130802499665E-03   0.00000000000000E+00   2.07222818776180E-12
      1.78791925656206E-22  -6.63954972687091E-09  -6.63747749868297E-09  -1.90143043783389E-18
      1.26249118210436E-08
      0.00000000000000E+00  -8.77705046650009E-12   0.00000000000000E+00   2.87081024074245E-14   1.31416620733861E-22
      8.77701776699595E-09   8.77704647509849E-09  -5.62543665090978E-19  -3.64519271945880E-01  -3.64519271943589E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29142993361686E-09   0.00000000000000E+00  -2.29142993361686E-09
      2.38395591223531E-18  -7.32317738360807E-03  -5.27977670382807E-03   0.00000000000000E+00   1.83818827799393E-12
      1.93464036574080E-22  -6.48745472975982E-09  -6.48561654148163E-09  -1.82141224714433E-18
      1.26499118210436E-08
      0.00000000000000E+00  -8.83978042201283E-12   0.00000000000000E+00   1.39559413423790E-13   1.29380330668675E-22
      8.83967637505262E-09   8.83981593446617E-09  -5.44573978358891E-19  -3.72253700856378E-01  -3.72253700853964E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41388417331157E-09   0.00000000000000E+00  -2.41388417331157E-09
      2.32360880790252E-18  -6.77118772856742E-03  -4.74659073606031E-03   0.00000000000000E+00   1.74631641654334E-12
      1.94523961234448E-22  -6.42767807757133E-09  -6.42593176115460E-09  -1.77903482954362E-18
      1.26836618210436E-08
      0.00000000000000E+00  -8.83491265094083E-12   0.00000000000000E+00   8.22295500214053E-15   1.22186402007622E-22
      8.83494537222988E-09   8.83495359518501E-09  -5.20603423284014E-19  -3.82573829520406E-01  -3.82573829517971E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43539821197845E-09   0.00000000000000E+00  -2.43539821197845E-09
      2.24141411824824E-18  -6.16882854297565E-03  -4.15254054095954E-03   0.00000000000000E+00   1.57210469004263E-12
      1.87513375413308E-22  -6.40112748789680E-09  -6.39955538320657E-09  -1.72081069496423E-18
      1.27064430710436E-08
      0.00000000000000E+00  -8.78099979020001E-12   0.00000000000000E+00  -1.02442417561925E-13   1.14374069750142E-22
      8.78111944529416E-09   8.78101700287672E-09  -5.04948371120207E-19  -3.89311115587305E-01  -3.89311115584903E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40272688557703E-09   0.00000000000000E+00  -2.40272688557703E-09
      2.18667699638619E-18  -5.82285726028257E-03  -3.81326837905537E-03   0.00000000000000E+00   1.46251601995417E-12
      1.77172537014122E-22  -6.37975263331979E-09  -6.37829011729965E-09  -1.68172862526599E-18
      1.27218204147936E-08
      0.00000000000000E+00  -8.72341313997089E-12   0.00000000000000E+00  -1.71346041210064E-13   1.07893957006818E-22
      8.72354625805880E-09   8.72337491201770E-09  -4.94714474252680E-19  -3.93714072508683E-01  -3.93714072506327E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35571164218985E-09   0.00000000000000E+00  -2.35571164218985E-09
      2.15045240868836E-18  -5.61650398702448E-03  -3.61026270934818E-03   0.00000000000000E+00   1.36565301074215E-12
      1.67882627504376E-22  -6.36902892283866E-09  -6.36766326982775E-09  -1.65573793443568E-18
      1.27425798288561E-08
      0.00000000000000E+00  -8.61375052374510E-12   0.00000000000000E+00  -2.48038843684229E-13   9.80909170466956E-23
      8.61396444822137E-09   8.61371640937778E-09  -4.81671799578776E-19  -3.99323786879804E-01  -3.99323786877556E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.24831657302073E-09   0.00000000000000E+00  -2.24831657302073E-09
      2.10377867400544E-18  -5.37527773661257E-03  -3.36974887606961E-03   0.00000000000000E+00   1.23117482135011E-12
      1.53240000721776E-22  -6.36663101117852E-09  -6.36539983635701E-09  -1.62210687442666E-18
      1.27706050378405E-08
      0.00000000000000E+00  -8.39938490710274E-12   0.00000000000000E+00  -3.66343874603423E-13   8.37726918170762E-23
      8.39972615970262E-09   8.39935981582810E-09  -4.66021731685519E-19  -4.06054289912049E-01  -4.06054289910020E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02863615179893E-09   0.00000000000000E+00  -2.02863615179893E-09
      2.04692572189802E-18  -5.10361469347854E-03  -3.09640758536793E-03   0.00000000000000E+00   1.04781431529567E-12
      1.31073973921815E-22  -6.37177147834461E-09  -6.37072366402918E-09  -1.58090399021250E-18
      1.28084390699694E-08
      0.00000000000000E+00  -7.92243518678405E-12   0.00000000000000E+00  -6.13742937741837E-13   6.42870935459816E-23
      7.92310727418253E-09   7.92249353124485E-09  -4.50872636267210E-19  -4.12614495803226E-01  -4.12614495801715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51027689700395E-09   0.00000000000000E+00  -1.51027689700395E-09
      1.98978585725323E-18  -4.83365654451983E-03  -2.81337532151859E-03   0.00000000000000E+00   6.82814292539613E-13
      9.99980583467016E-23  -6.41289944853357E-09  -6.41221663424093E-09  -1.53891322098602E-18
      1.28584390699694E-08
      0.00000000000000E+00  -6.52749731807613E-12   0.00000000000000E+00  -1.37563839104083E-12   4.03290335914598E-23
      6.52884888218509E-09   6.52747324379408E-09  -4.53625233600470E-19  -4.11897178857776E-01  -4.11897178857743E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.36531163997303E-11   0.00000000000000E+00  -3.36531163997303E-11
      1.98810320143324E-18  -4.61900235528883E-03  -2.57300963429868E-03   0.00000000000000E+00  -1.58034124375167E-13
      6.07920587169171E-23  -6.49366209327003E-09  -6.49382012739435E-09  -1.53447796783277E-18
      1.29084390699694E-08
      0.00000000000000E+00  -3.96135536049784E-12   0.00000000000000E+00  -2.56604752442983E-12   1.65330236800461E-23
      3.96387339381537E-09   3.96130734629096E-09  -4.99393543731752E-19  -3.93788617212431E-01  -3.93788617214992E-01
      0.00000000000000E+00   0.00000000000000E+00   2.56137874942441E-09   0.00000000000000E+00   2.56137874942441E-09
      2.11617213890446E-18  -4.59436094737968E-03  -2.53926714819380E-03   0.00000000000000E+00  -1.68976421635640E-12
      2.02582054741721E-23  -6.52099633149903E-09  -6.52268609571536E-09  -1.61677859517271E-18
      1.29584390699694E-08
      0.00000000000000E+00  -1.23981210756440E-12   0.00000000000000E+00  -2.72658337321835E-12  -1.17817510786695E-23
      1.24255394565260E-09   1.23982736227937E-09  -5.98613411562148E-19  -3.54141457495063E-01  -3.54141457500281E-01
      0.00000000000000E+00   0.00000000000000E+00   5.21760887342929E-09   0.00000000000000E+00   5.21760887342929E-09
      2.37705258257593E-18  -5.41895728707542E-03  -3.38442955902903E-03   0.00000000000000E+00  -4.36712602019285E-12
     -3.09102832674396E-23  -6.45306910968845E-09  -6.45743623570867E-09  -1.77843917101378E-18
      1.30084390699694E-08
      0.00000000000000E+00   3.79686143615916E-13   0.00000000000000E+00  -1.68015581891007E-12  -3.41677988583912E-23
     -3.77977484155091E-10  -3.79657639974035E-10  -7.35020199267868E-19  -2.97372832856903E-01  -2.97372832863438E-01
      0.00000000000000E+00   0.00000000000000E+00   6.53427170788427E-09   0.00000000000000E+00   6.53427170788427E-09
      2.70376616797014E-18  -1.03687660623401E-02  -8.42965102216342E-03   0.00000000000000E+00  -8.72475186134744E-12
     -6.99952680135527E-23  -6.14588931604879E-09  -6.15461406791021E-09  -1.96874596870227E-18
      1.30584390699694E-08
      0.00000000000000E+00   1.48852765592239E-12   0.00000000000000E+00  -1.21476923066120E-12  -4.14206681067075E-23
     -1.48733340390513E-09  -1.48854817313584E-09  -8.71811231447435E-19  -2.35262654433724E-01  -2.35262654440376E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65200503494676E-09   0.00000000000000E+00   6.65200503494676E-09
      3.03636641971748E-18  -2.91882903614645E-02  -2.75614580233850E-02   0.00000000000000E+00  -1.61697786131368E-11
     -8.13604033278144E-23  -5.14728708319771E-09  -5.16345686181093E-09  -2.16455518827004E-18
      1.30834390699694E-08
      0.00000000000000E+00   1.90146159440743E-12   0.00000000000000E+00  -9.64036652666590E-13  -4.26724624756349E-23
     -1.90056698326331E-09  -1.90153101991602E-09  -9.35720234959781E-19  -2.04220329337642E-01  -2.04220329344037E-01
      0.00000000000000E+00   0.00000000000000E+00   6.39503450441934E-09   0.00000000000000E+00   6.39503450441934E-09
      3.19624228232796E-18  -4.30109912493130E-02  -4.15952354183770E-02   0.00000000000000E+00  -2.42249700798855E-11
     -8.54245183049074E-23  -4.46927851442341E-09  -4.49350348450338E-09  -2.26052204736818E-18
      1.31171890699694E-08
      0.00000000000000E+00   2.13906392956330E-12   0.00000000000000E+00  -5.15224793046199E-13  -4.38085347873107E-23
     -2.13857182750839E-09  -2.13908705230148E-09  -1.01479328433219E-18  -1.63985013107053E-01  -1.63985013113077E-01
      0.00000000000000E+00   0.00000000000000E+00   6.02419196515404E-09   0.00000000000000E+00   6.02419196515404E-09
      3.39955876115191E-18  -6.54937368577656E-02  -6.42696658857795E-02   0.00000000000000E+00  -3.29764711019197E-11
     -9.18316729684789E-23  -3.85212844175055E-09  -3.88510491285256E-09  -2.38476547681972E-18
      1.31399703199694E-08
      0.00000000000000E+00   2.12565459793100E-12   0.00000000000000E+00  -1.60259275334278E-13  -4.45538855300344E-23
     -2.12552989661989E-09  -2.12569015589527E-09  -1.06472555180801E-18  -1.37546523254987E-01  -1.37546523260648E-01
      0.00000000000000E+00   0.00000000000000E+00   5.66134853607045E-09   0.00000000000000E+00   5.66134853607045E-09
      3.52853135748926E-18  -8.16629055619555E-02  -8.05489305469133E-02   0.00000000000000E+00  -4.20020947800781E-11
     -9.63234187066720E-23  -3.49365628539497E-09  -3.53565838017514E-09  -2.46380580568126E-18
      1.31553476637194E-08
      0.00000000000000E+00   2.06476153716241E-12   0.00000000000000E+00  -6.59119296644647E-15  -4.50587303489313E-23
     -2.06478985791162E-09  -2.06479644910463E-09  -1.09668986370925E-18  -1.20181982104459E-01  -1.20181982109851E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39170398670881E-09   0.00000000000000E+00   5.39170398670881E-09
      3.61144144309113E-18  -9.28406559820438E-02  -9.17924493629245E-02   0.00000000000000E+00  -4.83741941906941E-11
     -9.93735407328326E-23  -3.27853334341339E-09  -3.32690753760418E-09  -2.51475157938188E-18
      1.31761070777819E-08
      0.00000000000000E+00   1.95564998935987E-12   0.00000000000000E+00   5.17550472115993E-14  -4.57153275444967E-23
     -1.95565258289482E-09  -1.95560082784765E-09  -1.13673132515036E-18  -9.79243871329391E-02  -9.79243871379956E-02
      0.00000000000000E+00   0.00000000000000E+00   5.05654891640023E-09   0.00000000000000E+00   5.05654891640023E-09
      3.71641243577397E-18  -1.08058043856044E-01  -1.07081029602637E-01   0.00000000000000E+00  -5.36896161204205E-11
     -1.03465955789274E-22  -3.04725847243208E-09  -3.10094808855260E-09  -2.57968111062361E-18
      1.32041322867663E-08
      0.00000000000000E+00   1.74541738589184E-12   0.00000000000000E+00   1.63466523151753E-13  -4.65079329043926E-23
     -1.74549670414395E-09  -1.74533323762085E-09  -1.18418533376113E-18  -7.07990665392475E-02  -7.07990665438005E-02
      0.00000000000000E+00   0.00000000000000E+00   4.55299104837947E-09   0.00000000000000E+00   4.55299104837947E-09
      3.84401096140879E-18  -1.28607056283635E-01  -1.27722448713443E-01   0.00000000000000E+00  -5.93912701383386E-11
     -1.08910410455508E-22  -2.74826654062025E-09  -2.80765781075870E-09  -2.65982562764767E-18
      1.32419663188952E-08
      0.00000000000000E+00   1.30970595257933E-12   0.00000000000000E+00   3.95722229574633E-13  -4.72825692084376E-23
     -1.31006091962915E-09  -1.30966519739963E-09  -1.23137190901556E-18  -4.29789572036390E-02  -4.29789572073037E-02
      0.00000000000000E+00   0.00000000000000E+00   3.66473801922209E-09   0.00000000000000E+00   3.66473801922209E-09
      3.98266277737207E-18  -1.56469378819378E-01  -1.55727367184585E-01   0.00000000000000E+00  -6.19652487869565E-11
     -1.15740896710097E-22  -2.29310757303539E-09  -2.35507282182246E-09  -2.75129086835651E-18
      1.32919663188952E-08
      0.00000000000000E+00   7.03622531746862E-13   0.00000000000000E+00   5.04491259485956E-13  -4.77649776388705E-23
     -7.04105805872580E-10  -7.03601314613142E-10  -1.26336741416539E-18  -2.35800644023289E-02  -2.35800644047598E-02
      0.00000000000000E+00   0.00000000000000E+00   2.43084873055086E-09   0.00000000000000E+00   2.43084873055086E-09
      4.10420521389961E-18  -1.91722067304575E-01  -1.91177864574701E-01   0.00000000000000E+00  -5.57967049046017E-11
     -1.22993793816012E-22  -1.67145071103299E-09  -1.72724741593772E-09  -2.84083779973422E-18
      1.33419663188952E-08
      0.00000000000000E+00   3.40192906616679E-13   0.00000000000000E+00   3.22053787343539E-13  -4.79381694353993E-23
     -3.40477420918459E-10  -3.40155367131163E-10  -1.27724866535474E-18  -1.50682286807573E-02  -1.50682286823042E-02
      0.00000000000000E+00   0.00000000000000E+00   1.54687211745417E-09   0.00000000000000E+00   1.54687211745417E-09
      4.18154881977232E-18  -2.21032579451010E-01  -2.20652380212200E-01   0.00000000000000E+00  -4.47872631479150E-11
     -1.28283881803615E-22  -1.16192948717497E-09  -1.20671675032301E-09  -2.90430015441757E-18
      1.33919663188952E-08
      0.00000000000000E+00   1.97741719207805E-13   0.00000000000000E+00   1.27562668313520E-13  -4.80002770603474E-23
     -1.97893349825763E-10  -1.97765787157498E-10  -1.28407439197262E-18  -1.10034182241578E-02  -1.10034182251881E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03027593443842E-09   0.00000000000000E+00   1.03027593443842E-09
      4.23306261649424E-18  -2.42070062333931E-01  -2.41807765493834E-01   0.00000000000000E+00  -3.21087697974447E-11
     -1.31840194247785E-22  -8.00401377483358E-10  -8.32510147280935E-10  -2.94898822452162E-18
      1.34419663188952E-08
      0.00000000000000E+00   1.42818566357704E-13   0.00000000000000E+00   5.00269569648548E-14  -4.80216687705247E-23
     -1.42859084854032E-10  -1.42809057897115E-10  -1.28820732205195E-18  -8.73088528396762E-03  -8.73088528468725E-03
      0.00000000000000E+00   0.00000000000000E+00   7.19634906208857E-10   0.00000000000000E+00   7.19634906208857E-10
      4.26904436180468E-18  -2.55924280069661E-01  -2.55742543184316E-01   0.00000000000000E+00  -2.09050888066184E-11
     -1.34068047098756E-22  -5.55920759504971E-10  -5.76825848311724E-10  -2.98083703975273E-18
      1.34919663188952E-08
      0.00000000000000E+00   1.16642816253559E-13   0.00000000000000E+00   2.53874124925085E-14  -4.80243697937843E-23
     -1.16699679033694E-10  -1.16674291621249E-10  -1.29108286783443E-18  -7.29543661798998E-03  -7.29543661854626E-03
      0.00000000000000E+00   0.00000000000000E+00   5.56279946385664E-10   0.00000000000000E+00   5.56279946385664E-10
      4.29685835912397E-18  -2.65750392664675E-01  -2.65611890781080E-01   0.00000000000000E+00  -1.42751085863417E-11
     -1.35550704710024E-22  -4.25330546177935E-10  -4.39605654764412E-10  -3.00577549128954E-18
      1.35169663188952E-08
      0.00000000000000E+00   1.05805137263071E-13   0.00000000000000E+00   2.24939814966436E-14  -4.80217190610000E-23
     -1.05867846646330E-10  -1.05845352664882E-10  -1.29226174071485E-18  -6.74754299904413E-03  -6.74754299953616E-03
      0.00000000000000E+00   0.00000000000000E+00   4.92029567602234E-10   0.00000000000000E+00   4.92029567602234E-10
      4.30915909831402E-18  -2.69879602542859E-01  -2.69757932557268E-01   0.00000000000000E+00  -1.15918382766080E-11
     -1.36144190438599E-22  -3.74592376660575E-10  -3.86184214937319E-10  -3.01689735759917E-18
      1.35507163188952E-08
      0.00000000000000E+00   9.80901793376386E-14   0.00000000000000E+00   1.33665581037577E-14  -4.80151559108777E-23
     -9.81066813343222E-11  -9.80933147762665E-11  -1.29361289369887E-18  -6.14966345436574E-03  -6.14966345482584E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60098439586028E-10   0.00000000000000E+00   4.60098439586028E-10
      4.32468742065005E-18  -2.75036489315429E-01  -2.74922437651867E-01   0.00000000000000E+00  -1.04980100405307E-11
     -1.36859106824697E-22  -3.51507114769132E-10  -3.62005124809799E-10  -3.03107452695118E-18
      1.35734975688952E-08
      0.00000000000000E+00   9.33142530028472E-14   0.00000000000000E+00   1.28327494632802E-14  -4.80093755012949E-23
     -9.33610218582502E-11  -9.33481891088349E-11  -1.29442638671937E-18  -5.80638942940892E-03  -5.80638942984460E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35679328255072E-10   0.00000000000000E+00   4.35679328255072E-10
      4.33461274034686E-18  -2.78257897450726E-01  -2.78150044649112E-01   0.00000000000000E+00  -9.50062047547880E-12
     -1.37291886431067E-22  -3.32830518670649E-10  -3.42331139146265E-10  -3.04018635362749E-18
      1.35888749126452E-08
      0.00000000000000E+00   9.00996872005837E-14   0.00000000000000E+00   1.34312076078730E-14  -4.80048181292819E-23
     -9.00889567174272E-11  -9.00755255098674E-11  -1.29492951807617E-18  -5.60167015170065E-03  -5.60167015212387E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23219910208774E-10   0.00000000000000E+00   4.23219910208774E-10
      4.34112073838799E-18  -2.80361359075366E-01  -2.80256400821363E-01   0.00000000000000E+00  -9.07285364409649E-12
     -1.37568923154742E-22  -3.24071531054691E-10  -3.33144384698925E-10  -3.04619122031181E-18
      1.36096343267077E-08
      0.00000000000000E+00   8.62422082378676E-14   0.00000000000000E+00   1.24210672277721E-14  -4.79977267193649E-23
     -8.62717991673082E-11  -8.62593781001284E-11  -1.29553755827460E-18  -5.36239823406842E-03  -5.36239823448726E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18839508587206E-10   0.00000000000000E+00   4.18839508587206E-10
      4.34981560117248E-18  -2.83241698817597E-01  -2.83136918339915E-01   0.00000000000000E+00  -9.19511775359890E-12
     -1.37944551602721E-22  -3.23385012733405E-10  -3.32580130487142E-10  -3.05427804289788E-18
      1.36376595356921E-08
      0.00000000000000E+00   8.16499713774913E-14   0.00000000000000E+00   1.19012376326503E-14  -4.79866609583895E-23
     -8.16845650044142E-11  -8.16726637668296E-11  -1.29624494624972E-18  -5.09322778814784E-03  -5.09322778857006E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22224672603872E-10   0.00000000000000E+00   4.22224672603872E-10
      4.36164853586056E-18  -2.87367599380222E-01  -2.87260307123433E-01   0.00000000000000E+00  -9.88024955569830E-12
     -1.38483396269867E-22  -3.30671759281178E-10  -3.40552008837014E-10  -3.06540358961084E-18
      1.36754935678210E-08
      0.00000000000000E+00   7.43023924008891E-14   0.00000000000000E+00   1.43289441270372E-14  -4.79680244202423E-23
     -7.42895830775899E-11  -7.42752541335108E-11  -1.29695036668758E-18  -4.82640344141469E-03  -4.82640344187737E-03
      0.00000000000000E+00   0.00000000000000E+00   4.62681840748092E-10   0.00000000000000E+00   4.62681840748092E-10
      4.37915365548889E-18  -2.94421444376577E-01  -2.94299074096433E-01   0.00000000000000E+00  -1.32364207680716E-11
     -1.39441344165697E-22  -3.75170165846330E-10  -3.88406586614541E-10  -3.08220328880130E-18
      1.37254935678210E-08
      0.00000000000000E+00   6.44750055196838E-14   0.00000000000000E+00   1.55036240675385E-14  -4.79370515529443E-23
     -6.44812336007197E-11  -6.44657299767001E-11  -1.29745365141435E-18  -4.61464073237430E-03  -4.61464073291608E-03
      0.00000000000000E+00   0.00000000000000E+00   5.41778420978586E-10   0.00000000000000E+00   5.41778420978586E-10
      4.40624257653782E-18  -3.07273421578196E-01  -3.07123038838586E-01   0.00000000000000E+00  -1.96068768789710E-11
     -1.41275997027304E-22  -4.57705814122750E-10  -4.77312691001863E-10  -3.10878892512347E-18
      1.37754935678210E-08
      0.00000000000000E+00   5.44639291640634E-14   0.00000000000000E+00   1.67935021824775E-14  -4.78996376718720E-23
     -5.45433896018851E-11  -5.45265960997505E-11  -1.29752666974522E-18  -4.59850316894851E-03  -4.59850316951691E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68396560510162E-10   0.00000000000000E+00   5.68396560510162E-10
      4.43466240456333E-18  -3.21758781881491E-01  -3.21596880776873E-01   0.00000000000000E+00  -2.29589483024846E-11
     -1.43370280668890E-22  -4.90911016107855E-10  -5.13869964410483E-10  -3.13713573481810E-18
      1.38254935678210E-08
      0.00000000000000E+00   2.31448737762967E-14   0.00000000000000E+00   4.26743844054019E-14  -4.78359053260324E-23
     -2.31873944053351E-11  -2.31447200209775E-11  -1.29610608206200E-18  -5.46479895335396E-03  -5.46479895386277E-03
      0.00000000000000E+00   0.00000000000000E+00   5.08810955930470E-10   0.00000000000000E+00   5.08810955930470E-10
      4.46010295235985E-18  -3.36082037346389E-01  -3.35929022874437E-01   0.00000000000000E+00  -2.18458315645159E-11
     -1.45314406842478E-22  -4.63820404344761E-10  -4.85666235909423E-10  -3.16399687029785E-18
      1.38754935678210E-08
      0.00000000000000E+00  -1.23806705755746E-13   0.00000000000000E+00   1.79928545194821E-13  -4.76408758856448E-23
      1.23602180887792E-10   1.23782109432940E-10  -1.28747012509073E-18  -1.06144294853613E-02  -1.06144294856079E-02
      0.00000000000000E+00   0.00000000000000E+00   2.46618678120514E-10   0.00000000000000E+00   2.46618678120514E-10
      4.47243388626587E-18  -3.50111255136899E-01  -3.49994559065145E-01   0.00000000000000E+00  -1.37306183065997E-11
     -1.46520385946136E-22  -3.56670169246724E-10  -3.70400787553470E-10  -3.18496376117514E-18
      1.39254935678210E-08
      0.00000000000000E+00  -6.18666149829900E-13   0.00000000000000E+00   5.95062467025083E-13  -4.70086788987634E-23
      6.18058438353968E-10   6.18653500820946E-10  -1.25457279458398E-18  -2.98488192961596E-02  -2.98488192955907E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.68915076932897E-10   0.00000000000000E+00  -5.68915076932897E-10
      4.44398813241923E-18  -3.65079466418180E-01  -3.65063806577264E-01   0.00000000000000E+00   1.11519079445508E-11
     -1.45589352406235E-22  -6.08903318324258E-11  -4.97384238880205E-11  -3.18941533783524E-18
      1.39504935678210E-08
      0.00000000000000E+00  -9.48572445879336E-13   0.00000000000000E+00   7.93065448352905E-13  -4.65563190908093E-23
      9.47820773768146E-10   9.48613839216452E-10  -1.23016546556260E-18  -4.38144302703888E-02  -4.38144302692942E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.09463417276911E-09   0.00000000000000E+00  -1.09463417276911E-09
      4.41662227810000E-18  -3.72817992675982E-01  -3.72864013909214E-01   0.00000000000000E+00   2.60423791264662E-11
     -1.44473147392858E-22   1.19977954426276E-10   1.46020333552597E-10  -3.18645681253740E-18
      1.39842435678210E-08
      0.00000000000000E+00  -1.20537033111158E-12   0.00000000000000E+00   5.32044425017735E-13  -4.58511023327645E-23
      1.20487033317604E-09   1.20540237760101E-09  -1.18968040748494E-18  -6.63822496137937E-02  -6.63822496123238E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.46994068259677E-09   0.00000000000000E+00  -1.46994068259677E-09
      4.36701178006236E-18  -3.83116805091739E-01  -3.83200171026379E-01   0.00000000000000E+00   3.51307074884203E-11
     -1.42382224969578E-22   2.29407597507481E-10   2.64538304995759E-10  -3.17733137257742E-18
      1.40070248178210E-08
      0.00000000000000E+00  -1.35875104224815E-12   0.00000000000000E+00   4.84297571265524E-13  -4.53559325149460E-23
      1.35827244207509E-09   1.35875673964631E-09  -1.15984661805196E-18  -8.25780721857670E-02  -8.25780721841127E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65426675043437E-09   0.00000000000000E+00  -1.65426675043437E-09
      4.32932551565403E-18  -3.89830888539873E-01  -3.89924015157037E-01   0.00000000000000E+00   3.81219053046133E-11
     -1.40804628985381E-22   2.57388105483624E-10   2.95510010788097E-10  -3.16947889760207E-18
      1.40224021615710E-08
      0.00000000000000E+00  -1.45978025317643E-12   0.00000000000000E+00   4.70374236894921E-13  -4.50105586373560E-23
      1.45932228336446E-09   1.45979265760131E-09  -1.13884945654025E-18  -9.37642828298288E-02  -9.37642828280791E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.74971148751046E-09   0.00000000000000E+00  -1.74971148751046E-09
      4.30241960064726E-18  -3.94214307111841E-01  -3.94305674306323E-01   0.00000000000000E+00   3.90689993920040E-11
     -1.39687058214207E-22   2.50849830517207E-10   2.89918829909072E-10  -3.16357014410701E-18
      1.40431615756335E-08
      0.00000000000000E+00  -1.58790366158093E-12   0.00000000000000E+00   4.43114985430791E-13  -4.44923439458466E-23
      1.58742817891998E-09   1.58787129390536E-09  -1.10974612440082E-18  -1.08984103722466E-01  -1.08984103720643E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82259905791272E-09   0.00000000000000E+00  -1.82259905791272E-09
      4.26458351213412E-18  -3.99789722756132E-01  -3.99863705466296E-01   0.00000000000000E+00   3.95413318444055E-11
     -1.38118028863696E-22   1.95186432163171E-10   2.34727764007438E-10  -3.15483738773331E-18
      1.40711867846178E-08
      0.00000000000000E+00  -1.83615998625287E-12   0.00000000000000E+00   5.64500538817315E-13  -4.34666654222920E-23
      1.83559403389036E-09   1.83615853442913E-09  -1.06945031013031E-18  -1.29535800732423E-01  -1.29535800730512E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.91123129767610E-09   0.00000000000000E+00  -1.91123129767610E-09
      4.21102085559927E-18  -4.06452984309394E-01  -4.06476674875208E-01   0.00000000000000E+00   4.01150023706176E-11
     -1.35881379883062E-22   3.49577608765031E-11   7.50727632469849E-11  -3.14157054546896E-18
      1.41090208167468E-08
      0.00000000000000E+00  -2.48522674409847E-12   0.00000000000000E+00   9.59814604901771E-13  -4.00751072250233E-23
      2.48425806053100E-09   2.48521787513586E-09  -1.01287670908915E-18  -1.57406585931144E-01  -1.57406585929055E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08817710962917E-09   0.00000000000000E+00  -2.08817710962917E-09
      4.13201669574272E-18  -4.12841265119329E-01  -4.12716234284231E-01   0.00000000000000E+00   4.27058409970243E-11
     -1.32466467665879E-22  -4.39746606503559E-10  -3.97040765506667E-10  -3.11913998665356E-18
      1.41590208167468E-08
      0.00000000000000E+00  -4.29273117234259E-12   0.00000000000000E+00   1.87439753428265E-12  -2.52602860751224E-23
      4.29084395908757E-09   4.29271835662182E-09  -9.38097891110995E-19  -1.92567716225953E-01  -1.92567716223591E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36269448743201E-09   0.00000000000000E+00  -2.36269448743201E-09
      4.01388197137111E-18  -4.11611639426904E-01  -4.11003683587721E-01   0.00000000000000E+00   4.86985516438511E-11
     -1.26807022337552E-22  -1.97872242083352E-09  -1.93002386918980E-09  -3.07578408026012E-18
      1.42090208167468E-08
      0.00000000000000E+00  -7.33214906075128E-12   0.00000000000000E+00   3.06011776146097E-12   8.73054805676706E-24
      7.32908144512366E-09   7.33214156288513E-09  -8.73465872323986E-19  -2.21678624125312E-01  -2.21678624122725E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58769299019646E-09   0.00000000000000E+00  -2.58769299019646E-09
      3.88449732186129E-18  -3.92718775968770E-01  -3.91224174742088E-01   0.00000000000000E+00   5.43928090901539E-11
     -1.19698327229928E-22  -4.79884138177876E-09  -4.74444857268872E-09  -3.01103144953731E-18
      1.42590208167468E-08
      0.00000000000000E+00  -1.05247639708221E-11   0.00000000000000E+00   3.18723132643301E-12   4.76275340230038E-23
      1.05215721705796E-08   1.05247594019061E-08  -8.26508157041442E-19  -2.42506485205282E-01  -2.42506485202531E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75036390747657E-09   0.00000000000000E+00  -2.75036390747657E-09
      3.74697912648746E-18  -3.52286841692742E-01  -3.49837647054446E-01   0.00000000000000E+00   5.64417783308115E-11
     -1.11663786137153E-22  -7.83083727276021E-09  -7.77439549442951E-09  -2.92047096944602E-18
      1.43090208167468E-08
      0.00000000000000E+00  -1.24702191943519E-11   0.00000000000000E+00   1.94146891548302E-12   7.29892495719433E-23
      1.24682676724371E-08   1.24702091413526E-08  -7.96512919415885E-19  -2.56213732242516E-01  -2.56213732239650E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86598936566146E-09   0.00000000000000E+00  -2.86598936566146E-09
      3.60367965820439E-18  -2.95078987666747E-01  -2.92053247947068E-01   0.00000000000000E+00   5.08835140671312E-11
     -1.03749008170589E-22  -9.65510328975815E-09  -9.60421977569112E-09  -2.80716673878850E-18
      1.43590208167468E-08
      0.00000000000000E+00  -1.32174679762724E-11   0.00000000000000E+00   7.50910894215313E-13   8.26268348775484E-23
      1.32167491293402E-08   1.32175000402345E-08  -7.76509005811439E-19  -2.65977012114537E-01  -2.65977012111634E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90281301197347E-09   0.00000000000000E+00  -2.90281301197347E-09
      3.45853900760572E-18  -2.32974165897997E-01  -2.29724523387307E-01   0.00000000000000E+00   3.86427039695227E-11
     -9.55984791644649E-23  -1.03533297322305E-08  -1.03146870282611E-08  -2.68203000179428E-18
      1.43840208167468E-08
      0.00000000000000E+00  -1.32722992843853E-11   0.00000000000000E+00   1.18697251544129E-13   8.33927621141162E-23
      1.32722133851962E-08   1.32723320824478E-08  -7.68528833075470E-19  -2.70086050476948E-01  -2.70086050474033E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91433927252941E-09   0.00000000000000E+00  -2.91433927252941E-09
      3.38568052579248E-18  -2.01978833841343E-01  -1.98715516067509E-01   0.00000000000000E+00   3.05176696036585E-11
     -9.17543063392773E-23  -1.03885104795220E-08  -1.03579928099184E-08  -2.61715169271701E-18
      1.44177708167468E-08
      0.00000000000000E+00  -1.32678907369993E-11   0.00000000000000E+00   1.78388053312421E-15   8.20205770120633E-23
      1.32678631378923E-08   1.32678649217729E-08  -7.58944674464710E-19  -2.75225117780992E-01  -2.75225117778105E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88669064548265E-09   0.00000000000000E+00  -2.88669064548265E-09
      3.28825471650744E-18  -1.61821948525744E-01  -1.58551294602286E-01   0.00000000000000E+00   2.46752506578242E-11
     -8.77653827058169E-23  -1.04058495269480E-08  -1.03811742762903E-08  -2.52931004204273E-18
      1.44405520667468E-08
      0.00000000000000E+00  -1.31529011260155E-11   0.00000000000000E+00  -2.41338011148365E-13   7.99815773325821E-23
      1.31531315553998E-08   1.31528902173887E-08  -7.53193013950038E-19  -2.78439228018212E-01  -2.78439228015338E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87391710142808E-09   0.00000000000000E+00  -2.87391710142808E-09
      3.22278329254053E-18  -1.35455731424529E-01  -1.32217258207496E-01   0.00000000000000E+00   2.08282622529500E-11
     -8.54281729051031E-23  -1.02998013782135E-08  -1.02789731159606E-08  -2.46959027859049E-18
      1.44559294104968E-08
      0.00000000000000E+00  -1.30425037518920E-11   0.00000000000000E+00  -3.46990257237049E-13   7.83605295800061E-23
      1.30428762248061E-08   1.30425292345489E-08  -7.49517888180720E-19  -2.80540184517513E-01  -2.80540184514651E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86186281612547E-09   0.00000000000000E+00  -2.86186281612547E-09
      3.17877544425163E-18  -1.18154046872418E-01  -1.14946535012258E-01   0.00000000000000E+00   1.85184205400998E-11
     -8.37277197352003E-23  -1.01991848389635E-08  -1.01806664184235E-08  -2.42925755607091E-18
      1.44766888245593E-08
      0.00000000000000E+00  -1.28974809118414E-11   0.00000000000000E+00  -3.37797137603030E-13   7.64890476719319E-23
      1.28977854719808E-08   1.28974476748433E-08  -7.44485810116985E-19  -2.83421656010015E-01  -2.83421656007182E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83330128876218E-09   0.00000000000000E+00  -2.83330128876218E-09
      3.11995776963440E-18  -9.60117109626307E-02  -9.28408970495534E-02   0.00000000000000E+00   1.62539606002503E-11
     -8.07572949577422E-23  -1.00804003466813E-08  -1.00641463860811E-08  -2.37547195951742E-18
      1.45047140335436E-08
      0.00000000000000E+00  -1.26041288212005E-11   0.00000000000000E+00  -5.08077699444733E-13   7.47023316559290E-23
      1.26046563282420E-08   1.26041482505426E-08  -7.37059308731859E-19  -2.87567703131805E-01  -2.87567703129022E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78297617706123E-09   0.00000000000000E+00  -2.78297617706123E-09
      3.04196428067372E-18  -6.91451595838356E-02  -6.60508829215393E-02   0.00000000000000E+00   1.34388090989615E-11
     -7.17908366053764E-23  -9.83461088258025E-09  -9.82117207348136E-09  -2.30490497194186E-18
      1.45425480656725E-08
      0.00000000000000E+00  -1.18537573182150E-11   0.00000000000000E+00  -9.66081901240428E-13   7.64762695461908E-23
      1.18547672542493E-08   1.18538011723481E-08  -7.22855538310063E-19  -2.94700617490362E-01  -2.94700617487700E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.66195830862882E-09   0.00000000000000E+00  -2.66195830862882E-09
      2.94125166449925E-18  -4.18977500018238E-02  -3.90017373101846E-02   0.00000000000000E+00   9.85277820638712E-12
     -3.75180810273767E-23  -9.20169564192562E-09  -9.19184286371927E-09  -2.21839612618919E-18
      1.45925480656725E-08
      0.00000000000000E+00  -1.05995255869090E-11   0.00000000000000E+00  -1.21959978618769E-12   8.97798655246928E-23
      1.06007364500060E-08   1.05995168502199E-08  -6.94198406936435E-19  -3.07635478354206E-01  -3.07635478351762E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44424927692982E-09   0.00000000000000E+00  -2.44424927692982E-09
      2.81903920065276E-18  -2.31066633918685E-02  -2.05372274517048E-02   0.00000000000000E+00   6.14269075063024E-12
      3.74027719824959E-23  -8.16141026404077E-09  -8.15526757329010E-09  -2.12484079371633E-18
      1.46425480656725E-08
      0.00000000000000E+00  -9.63736011992299E-12   0.00000000000000E+00  -9.30149755061855E-13   1.07843575307556E-22
      9.63829688423852E-09   9.63736673448357E-09  -6.60775798431614E-19  -3.22133344321025E-01  -3.22133344318760E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26475207911927E-09   0.00000000000000E+00  -2.26475207911927E-09
      2.70580159669680E-18  -1.48582161376529E-02  -1.25353607380114E-02   0.00000000000000E+00   3.82012113698246E-12
      1.04140227780461E-22  -7.37643477650137E-09  -7.37261465536429E-09  -2.04502579826518E-18
      1.46925480656725E-08
      0.00000000000000E+00  -9.05754429393187E-12   0.00000000000000E+00  -5.54474300117945E-13   1.22203311185857E-22
      9.05810221279745E-09   9.05754773849745E-09  -6.27552862530795E-19  -3.36444135892347E-01  -3.36444135890195E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15143738759217E-09   0.00000000000000E+00  -2.15143738759217E-09
      2.59822972731719E-18  -1.08936005611529E-02  -8.71772101194092E-03   0.00000000000000E+00   2.62047889989059E-12
      1.51480087042466E-22  -6.90873082980534E-09  -6.90611035090529E-09  -1.97067686478639E-18
      1.47425480656725E-08
      0.00000000000000E+00  -8.75427297167262E-12   0.00000000000000E+00  -2.83086773147678E-13   1.29647557993546E-22
      8.75460007272809E-09   8.75431698595507E-09  -5.95066104875537E-19  -3.50479986060779E-01  -3.50479986058649E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13019314823095E-09   0.00000000000000E+00  -2.13019314823095E-09
      2.49172006990564E-18  -8.66464343076709E-03  -6.57760571484973E-03   0.00000000000000E+00   2.04909201255728E-12
      1.79876625099529E-22  -6.62617292973689E-09  -6.62412383772415E-09  -1.89665396503010E-18
      1.47925480656725E-08
      0.00000000000000E+00  -8.78513280337435E-12   0.00000000000000E+00   4.62927637120285E-14   1.31176874606011E-22
      8.78507127334385E-09   8.78511756610769E-09  -5.60322227034081E-19  -3.65480983181333E-01  -3.65480983179027E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30540424518466E-09   0.00000000000000E+00  -2.30540424518466E-09
      2.37644985764641E-18  -7.25135129821959E-03  -5.20981040334945E-03   0.00000000000000E+00   1.82938838295863E-12
      1.93668319771574E-22  -6.48154270930615E-09  -6.47971332092300E-09  -1.81612763061232E-18
      1.48175480656725E-08
      0.00000000000000E+00  -8.84299498781509E-12   0.00000000000000E+00   1.29951736228403E-13   1.28811952074583E-22
      8.84288792004925E-09   8.84301787178561E-09  -5.42335294108566E-19  -3.73221830176849E-01  -3.73221830174428E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42064502709725E-09   0.00000000000000E+00  -2.42064502709725E-09
      2.31593373196898E-18  -6.70994184573796E-03  -4.68646602537509E-03   0.00000000000000E+00   1.73434229038425E-12
      1.94095827574664E-22  -6.42410718697898E-09  -6.42237284468841E-09  -1.77359843786041E-18
      1.48512980656725E-08
      0.00000000000000E+00  -8.82885089828513E-12   0.00000000000000E+00  -5.44884722174338E-15   1.21133853336380E-22
      8.82888269671743E-09   8.82887724787033E-09  -5.18450173436232E-19  -3.83504345845364E-01  -3.83504345842932E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43180101573949E-09   0.00000000000000E+00  -2.43180101573949E-09
      2.23386044768777E-18  -6.11924125626695E-03  -4.10373423453326E-03   0.00000000000000E+00   1.55711062717731E-12
      1.86166093602800E-22  -6.39863334275820E-09  -6.39707623213083E-09  -1.71541027425154E-18
      1.48740793156725E-08
      0.00000000000000E+00  -8.76961104278628E-12   0.00000000000000E+00  -1.14128219558318E-13   1.13034467779523E-22
      8.76972405011687E-09   8.76960992189743E-09  -5.02888092858259E-19  -3.90201025151048E-01  -3.90201025148655E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39306869078443E-09   0.00000000000000E+00  -2.39306869078443E-09
      2.17934335157584E-18  -5.78029633758333E-03  -3.77125835923571E-03   0.00000000000000E+00   1.44565553181659E-12
      1.75270017955258E-22  -6.37798688664492E-09  -6.37654123111292E-09  -1.67645525871758E-18
      1.49048340031725E-08
      0.00000000000000E+00  -8.62330237641469E-12   0.00000000000000E+00  -2.21994165048643E-13   9.93909919802627E-23
      8.62349788290746E-09   8.62327588874251E-09  -4.83426076341232E-19  -3.98573691520879E-01  -3.98573691518624E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25479051598768E-09   0.00000000000000E+00  -2.25479051598768E-09
      2.10999797387867E-18  -5.40672340328092E-03  -3.40022249113556E-03   0.00000000000000E+00   1.26180793869641E-12
      1.55236588639014E-22  -6.36974718069370E-09  -6.36848537275485E-09  -1.62657189753744E-18
      1.49463528312975E-08
      0.00000000000000E+00  -8.28320131453522E-12   0.00000000000000E+00  -3.93608953583262E-13   7.86437365280193E-23
      8.28360725553171E-09   8.28321364657820E-09  -4.61719789388160E-19  -4.07917515714232E-01  -4.07917515712325E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90758398039193E-09   0.00000000000000E+00  -1.90758398039193E-09
      2.03079732246277E-18  -5.02436601534623E-03  -3.01561296089281E-03   0.00000000000000E+00   9.79041283323144E-13
      1.23001600252097E-22  -6.37660870746969E-09  -6.37562966618624E-09  -1.56907753307461E-18
      1.49963528312975E-08
      0.00000000000000E+00  -7.43216797957027E-12   0.00000000000000E+00  -8.34325117610582E-13   5.38518270839297E-23
      7.43296549015418E-09   7.43213116503663E-09  -4.49634519426286E-19  -4.13297410329258E-01  -4.13297410328269E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.88952718990713E-10   0.00000000000000E+00  -9.88952718990713E-10
      1.98134968651324E-18  -4.73519370107939E-03  -2.70515701173427E-03   0.00000000000000E+00   3.81909482856580E-13
      8.30208097365727E-23  -6.44356035552889E-09  -6.44317844604595E-09  -1.53171516708695E-18
      1.50000000000000E-08
      0.00000000000000E+00  -7.34932402660908E-12   0.00000000000000E+00  -1.11039086179876E-12   5.19611878389241E-23
      7.35051485414890E-09   7.34940446328715E-09  -4.48861828523486E-19  -4.13643883619799E-01  -4.13643883618901E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.97502724447322E-10   0.00000000000000E+00  -8.97502724447322E-10
      1.97807634266626E-18  -4.71411496203161E-03  -2.68132979918013E-03   0.00000000000000E+00   2.74380612501585E-13
      7.99257330022701E-23  -6.45217611945239E-09  -6.45190173883981E-09  -1.52921451414278E-18
}
